/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import javax.inject.Provider;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.ServiceLocatorProvider;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsTracker;
import ru.vyarus.dropwizard.guice.module.installer.scanner.InvisibleForScanner;
import ru.vyarus.dropwizard.guice.module.installer.util.JerseyBinding;
import ru.vyarus.dropwizard.guice.module.jersey.hk2.GuiceBridgeActivator;
import ru.vyarus.dropwizard.guice.module.jersey.hk2.InstallerBinder;
import ru.vyarus.dropwizard.guice.module.lifecycle.internal.LifecycleSupport;

@InvisibleForScanner
public class GuiceFeature
implements Feature,
Provider<ServiceLocator> {
    private final Provider<Injector> provider;
    private final StatsTracker tracker;
    private final LifecycleSupport lifecycle;
    private final boolean enableBridge;
    private ServiceLocator locator;

    public GuiceFeature(Provider<Injector> provider, StatsTracker tracker, LifecycleSupport lifecycle, boolean enableBridge) {
        this.provider = provider;
        this.tracker = tracker;
        this.lifecycle = lifecycle;
        this.enableBridge = enableBridge;
    }

    public boolean configure(FeatureContext context) {
        this.tracker.startHkTimer(Stat.HKTime);
        this.locator = ServiceLocatorProvider.getServiceLocator((FeatureContext)context);
        this.lifecycle.hk2Configuration(this.locator);
        Injector injector = (Injector)this.provider.get();
        if (this.enableBridge) {
            Preconditions.checkState((boolean)JerseyBinding.isBridgeAvailable(), (Object)"HK2 bridge is requested, but dependency not found: 'org.glassfish.hk2:guice-bridge:2.5.0-b32' (check that dependency version match HK2 version used in your dropwizard)");
            new GuiceBridgeActivator(this.locator, injector).activate();
        }
        context.register((Object)new InstallerBinder(injector, this.tracker, this.lifecycle));
        this.tracker.stopHkTimer(Stat.HKTime);
        return true;
    }

    public ServiceLocator get() {
        return (ServiceLocator)Preconditions.checkNotNull((Object)this.locator, (Object)"Service locator is not yet available");
    }
}

