/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey.hk2;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsTracker;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsHolder;
import ru.vyarus.dropwizard.guice.module.lifecycle.internal.LifecycleSupport;

public class InstallerBinder
extends AbstractBinder {
    private final Injector injector;
    private final StatsTracker tracker;
    private final LifecycleSupport lifecycle;

    public InstallerBinder(Injector injector, StatsTracker tracker, LifecycleSupport lifecycle) {
        this.injector = injector;
        this.tracker = tracker;
        this.lifecycle = lifecycle;
    }

    protected void configure() {
        this.tracker.startHkTimer(Stat.JerseyInstallerTime);
        ExtensionsHolder holder = (ExtensionsHolder)this.injector.getInstance(ExtensionsHolder.class);
        ArrayList allInstalled = new ArrayList();
        for (FeatureInstaller installer : holder.getInstallers()) {
            if (!(installer instanceof JerseyInstaller)) continue;
            List<Class<?>> features = holder.getExtensions(installer.getClass());
            if (features != null) {
                for (Class<?> type : features) {
                    ((JerseyInstaller)((Object)installer)).install(this, this.injector, type);
                }
                allInstalled.addAll(features);
            }
            installer.report();
            this.lifecycle.hk2ExtensionsInstalled(installer.getClass(), features);
        }
        this.lifecycle.hk2ExtensionsInstalled(allInstalled);
        this.tracker.stopHkTimer(Stat.JerseyInstallerTime);
    }
}

