/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.lifecycle.debug;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import ru.vyarus.dropwizard.guice.module.context.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleAdapter;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ConfigurationHooksProcessedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.InitializationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.hk.HK2ConfigurationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.hk.HK2ExtensionsInstalledEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ApplicationRunEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BundlesFromDwResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BundlesFromLookupResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BundlesProcessedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsInstalledEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.InjectorCreationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.InstallersResolvedEvent;

public class DebugGuiceyLifecycle
extends GuiceyLifecycleAdapter {
    private static final String DISABLED = "disabled";
    private static final String NL = "\n";
    private final boolean showDetails;
    private final StopWatch timer = StopWatch.createStarted();

    public DebugGuiceyLifecycle(boolean showDetails) {
        this.showDetails = showDetails;
    }

    @Override
    protected void configurationHooksProcessed(ConfigurationHooksProcessedEvent event) {
        this.log("%s hooks processed", event.getHooks().size());
        if (this.showDetails) {
            this.logDetails("hooks", event.getHooks());
        }
    }

    @Override
    protected void initialization(InitializationEvent event) {
        if (!event.getCommands().isEmpty()) {
            this.log("%s commands installed", event.getCommands().size());
            if (this.showDetails) {
                this.logDetails("commands", event.getCommands());
            }
        }
    }

    @Override
    protected void dwBundlesResolved(BundlesFromDwResolvedEvent event) {
        this.log("%s dw bundles recognized", event.getBundles().size());
        if (this.showDetails) {
            this.logDetails("dropwizard bundles", event.getBundles());
        }
    }

    @Override
    protected void lookupBundlesResolved(BundlesFromLookupResolvedEvent event) {
        this.log("%s lookup bundles recognized", event.getBundles().size());
    }

    @Override
    protected void bundlesProcessed(BundlesProcessedEvent event) {
        this.log("Configured from %s%s GuiceyBundles", event.getBundles().size(), this.fmtDisabled(event.getDisabled()));
        if (this.showDetails) {
            this.logDetails("bundles", event.getBundles());
            this.logDetails(DISABLED, event.getDisabled());
        }
    }

    @Override
    protected void injectorCreation(InjectorCreationEvent event) {
        this.log("Staring guice with %s/%s%s modules...", event.getModules().size(), event.getOverridingModules().size(), this.fmtDisabled(event.getDisabled()));
        if (this.showDetails) {
            this.logDetails("modules", event.getModules());
            this.logDetails("overriding", event.getOverridingModules());
            this.logDetails(DISABLED, event.getDisabled());
        }
    }

    @Override
    protected void installersResolved(InstallersResolvedEvent event) {
        this.log("%s%s installers initialized", event.getInstallers().size(), this.fmtDisabled(event.getDisabled()));
        if (this.showDetails) {
            this.logDetails("installers", event.getInstallers());
            this.logDetails(DISABLED, event.getDisabled());
        }
    }

    @Override
    protected void extensionsResolved(ExtensionsResolvedEvent event) {
        this.log("%s%s extensions found", event.getExtensions().size(), this.fmtDisabled(event.getDisabled()));
        if (this.showDetails) {
            this.logDetails("extensions", event.getExtensions());
            this.logDetails(DISABLED, event.getDisabled());
        }
    }

    @Override
    protected void extensionsInstalled(ExtensionsInstalledEvent event) {
        this.log("%s extensions installed", event.getExtensions().size());
    }

    @Override
    protected void applicationRun(ApplicationRunEvent event) {
        this.log("Guice started, app running...", new Object[0]);
        event.registerJettyListener((LifeCycle.Listener)new JettyLifecycleListener());
        event.registerJerseyListener(new JerseyEventListener());
    }

    @Override
    protected void hk2Configuration(HK2ConfigurationEvent event) {
        this.log("Configuring HK2...", new Object[0]);
    }

    @Override
    protected void hk2ExtensionsInstalled(HK2ExtensionsInstalledEvent event) {
        this.log("%s HK2 extensions installed", event.getExtensions().size());
    }

    private void log(String message, Object ... args) {
        int gap = 70;
        String time = this.timer.toString();
        String msg = String.format(message, args);
        String topLine = String.format("%73s", "") + String.join((CharSequence)"", Collections.nCopies(msg.length(), "\u2500"));
        String prefix = "__[ " + time + " ]" + String.join((CharSequence)"", Collections.nCopies(64 - time.length(), "_"));
        System.out.println("\n\n" + topLine + NL + prefix + "/  " + msg + "  \\____\n");
    }

    private String fmtDisabled(List items) {
        return items.isEmpty() ? "" : " (-" + items.size() + ")";
    }

    private void logDetails(String message, Collection<?> items) {
        if (items.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder().append("\t").append(message).append(" = \n");
        for (Object item : items) {
            builder.append("\t\t").append(RenderUtils.renderClassLine(item instanceof Class ? (Class<?>)item : item.getClass(), null)).append(NL);
        }
        System.out.println(builder.toString());
    }

    private class JerseyEventListener
    implements ApplicationEventListener {
        private JerseyEventListener() {
        }

        @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
        public void onEvent(ApplicationEvent event) {
            switch (event.getType()) {
                case INITIALIZATION_START: {
                    DebugGuiceyLifecycle.this.log("Initializing jersey app...", new Object[0]);
                    break;
                }
                case INITIALIZATION_APP_FINISHED: {
                    DebugGuiceyLifecycle.this.log("Jersey app initialized", new Object[0]);
                    break;
                }
                case INITIALIZATION_FINISHED: {
                    DebugGuiceyLifecycle.this.log("Jersey initialized", new Object[0]);
                    break;
                }
                case DESTROY_FINISHED: {
                    DebugGuiceyLifecycle.this.log("Jersey app destroyed", new Object[0]);
                }
            }
        }

        public RequestEventListener onRequest(RequestEvent requestEvent) {
            return null;
        }
    }

    private class JettyLifecycleListener
    extends AbstractLifeCycle.AbstractLifeCycleListener {
        private JettyLifecycleListener() {
        }

        public void lifeCycleStarting(LifeCycle event) {
            DebugGuiceyLifecycle.this.log("Jetty starting...", new Object[0]);
        }

        public void lifeCycleStarted(LifeCycle event) {
            DebugGuiceyLifecycle.this.log("Jetty started", new Object[0]);
        }

        public void lifeCycleStopping(LifeCycle event) {
            DebugGuiceyLifecycle.this.timer.reset();
            DebugGuiceyLifecycle.this.log("Stopping Jetty...", new Object[0]);
        }

        public void lifeCycleStopped(LifeCycle event) {
            DebugGuiceyLifecycle.this.log("Jetty stopped", new Object[0]);
        }
    }
}

