/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.lifecycle.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.cli.Command;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.ServiceLocator;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.GuiceyLifecycleEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ConfigurationHooksProcessedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.InitializationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.hk.HK2ConfigurationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.hk.HK2ExtensionsInstalledByEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.hk.HK2ExtensionsInstalledEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ApplicationRunEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BeforeRunEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BundlesFromDwResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BundlesFromLookupResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BundlesProcessedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BundlesResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsInstalledByEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsInstalledEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.InjectorCreationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.InstallersResolvedEvent;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public final class LifecycleSupport {
    private final Options options;
    private Bootstrap bootstrap;
    private Configuration configuration;
    private ConfigurationTree configurationTree;
    private Environment environment;
    private Injector injector;
    private ServiceLocator locator;
    private GuiceyLifecycle currentStage;
    private final List<GuiceyLifecycleListener> listeners = new ArrayList<GuiceyLifecycleListener>();

    public LifecycleSupport(Options options) {
        this.options = options;
    }

    public void register(GuiceyLifecycleListener ... listeners) {
        Arrays.asList(listeners).forEach(l -> {
            this.listeners.add((GuiceyLifecycleListener)l);
            if (l instanceof GuiceyConfigurationHook) {
                Preconditions.checkState((boolean)this.isBefore(GuiceyLifecycle.ConfigurationHooksProcessed), (String)"Can't register listener as hook because hooks were already processed (current stage is %s).", (Object)((Object)this.currentStage));
                ((GuiceyConfigurationHook)((Object)l)).register();
            }
        });
    }

    public void configurationHooksProcessed(Set<GuiceyConfigurationHook> hooks) {
        if (hooks != null && !hooks.isEmpty()) {
            this.broadcast(new ConfigurationHooksProcessedEvent(this.options, hooks));
        }
    }

    public void initialization(Bootstrap bootstrap, List<Command> installed) {
        this.broadcast(new InitializationEvent(this.options, bootstrap, installed != null ? installed : Collections.emptyList()));
        this.bootstrap = bootstrap;
    }

    public void runPhase(Configuration configuration, ConfigurationTree configurationTree, Environment environment) {
        this.broadcast(new BeforeRunEvent(this.options, this.bootstrap, configuration, configurationTree, environment));
        this.configuration = configuration;
        this.configurationTree = configurationTree;
        this.environment = environment;
    }

    public void bundlesFromDwResolved(List<GuiceyBundle> bundles) {
        if (!bundles.isEmpty()) {
            this.broadcast(new BundlesFromDwResolvedEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, bundles));
        }
    }

    public void bundlesFromLookupResolved(List<GuiceyBundle> bundles) {
        if (!bundles.isEmpty()) {
            this.broadcast(new BundlesFromLookupResolvedEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, bundles));
        }
    }

    public void bundlesResolved(List<GuiceyBundle> bundles, List<GuiceyBundle> disabled) {
        this.broadcast(new BundlesResolvedEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, bundles, disabled));
    }

    public void bundlesProcessed(List<GuiceyBundle> bundles, List<GuiceyBundle> disabled) {
        if (!bundles.isEmpty()) {
            this.broadcast(new BundlesProcessedEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, bundles, disabled));
        }
    }

    public void injectorCreation(List<Module> modules, List<Module> overriding, List<Module> disabled) {
        this.broadcast(new InjectorCreationEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, modules, overriding, disabled));
    }

    public void installersResolved(List<FeatureInstaller> installers, List<Class<? extends FeatureInstaller>> disabled) {
        this.broadcast(new InstallersResolvedEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, installers, disabled));
    }

    public void extensionsResolved(List<Class<?>> extensions, List<Class<?>> disabled) {
        this.broadcast(new ExtensionsResolvedEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, extensions, disabled));
    }

    public void injectorPhase(Injector injector) {
        this.injector = injector;
    }

    public void extensionsInstalled(Class<? extends FeatureInstaller> installer, List<Class<?>> installed) {
        if (installed != null && !installed.isEmpty()) {
            this.broadcast(new ExtensionsInstalledByEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, installer, installed));
        }
    }

    public void extensionsInstalled(List<Class<?>> extensions) {
        if (!extensions.isEmpty()) {
            this.broadcast(new ExtensionsInstalledEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, extensions));
        }
    }

    public void applicationRun() {
        this.broadcast(new ApplicationRunEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector));
    }

    public void hk2Configuration(ServiceLocator locator) {
        this.broadcast(new HK2ConfigurationEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, locator));
        this.locator = locator;
    }

    public void hk2ExtensionsInstalled(Class<? extends FeatureInstaller> installer, List<Class<?>> installed) {
        if (installed != null && !installed.isEmpty()) {
            this.broadcast(new HK2ExtensionsInstalledByEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, this.locator, installer, installed));
        }
    }

    public void hk2ExtensionsInstalled(List<Class<?>> extensions) {
        if (!extensions.isEmpty()) {
            this.broadcast(new HK2ExtensionsInstalledEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, this.locator, extensions));
        }
    }

    public GuiceyLifecycle getStage() {
        return this.currentStage;
    }

    public boolean isBefore(GuiceyLifecycle lifecycle) {
        return this.getStage() == null || this.getStage().ordinal() < lifecycle.ordinal();
    }

    private void broadcast(GuiceyLifecycleEvent event) {
        this.listeners.forEach(l -> l.onEvent(event));
        this.currentStage = event.getType();
    }
}

