/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.spock.ext;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.SpecInfo;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.spock.UseGuiceyConfiguration;
import ru.vyarus.dropwizard.guice.test.spock.ext.GuiceyConfigurationHookInterceptor;

public class GuiceyConfigurationExtension
extends AbstractAnnotationDrivenExtension<UseGuiceyConfiguration> {
    private Class<? extends GuiceyConfigurationHook>[] confs;

    public void visitSpecAnnotation(UseGuiceyConfiguration annotation, SpecInfo spec) {
        this.confs = annotation.value();
    }

    public void visitSpec(SpecInfo spec) {
        GuiceyConfigurationHookInterceptor interceptor = new GuiceyConfigurationHookInterceptor(GuiceyConfigurationExtension.instantiate(this.confs));
        spec.getTopSpec().getSharedInitializerInterceptors().add(0, interceptor);
        spec.getTopSpec().addCleanupSpecInterceptor((IMethodInterceptor)interceptor);
    }

    @SafeVarargs
    public static final List<GuiceyConfigurationHook> instantiate(Class<? extends GuiceyConfigurationHook> ... confs) {
        return Arrays.stream(confs).map(conf -> {
            try {
                return (GuiceyConfigurationHook)conf.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate guicey hook: " + conf.getSimpleName(), e);
            }
        }).collect(Collectors.toList());
    }
}

