/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Predicate;
import javax.servlet.DispatcherType;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.bundle.DefaultBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.GuiceyBundleLookup;
import ru.vyarus.dropwizard.guice.bundle.lookup.VoidBundleLookup;
import ru.vyarus.dropwizard.guice.debug.ConfigurationDiagnostic;
import ru.vyarus.dropwizard.guice.debug.GuiceAopDiagnostic;
import ru.vyarus.dropwizard.guice.debug.GuiceBindingsDiagnostic;
import ru.vyarus.dropwizard.guice.debug.LifecycleDiagnostic;
import ru.vyarus.dropwizard.guice.debug.YamlBindingsDiagnostic;
import ru.vyarus.dropwizard.guice.debug.hook.DiagnosticHook;
import ru.vyarus.dropwizard.guice.debug.report.diagnostic.DiagnosticConfig;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceAopConfig;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceConfig;
import ru.vyarus.dropwizard.guice.debug.report.tree.ContextTreeConfig;
import ru.vyarus.dropwizard.guice.debug.report.yaml.BindingsConfig;
import ru.vyarus.dropwizard.guice.hook.ConfigurationHooksSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.injector.DefaultInjectorFactory;
import ru.vyarus.dropwizard.guice.injector.InjectorFactory;
import ru.vyarus.dropwizard.guice.module.GuiceyInitializer;
import ru.vyarus.dropwizard.guice.module.GuiceyRunner;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.unique.DuplicateConfigDetector;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.jersey.debug.HK2DebugBundle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;

public final class GuiceBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private Injector injector;
    private final ConfigurationContext context = new ConfigurationContext();
    private InjectorFactory injectorFactory = new DefaultInjectorFactory();
    private GuiceyBundleLookup bundleLookup = new DefaultBundleLookup();

    GuiceBundle() {
    }

    public void initialize(Bootstrap bootstrap) {
        GuiceyInitializer starter = new GuiceyInitializer(bootstrap, this.context);
        starter.initializeBundles(this.bundleLookup);
        starter.findCommands();
        starter.resolveInstallers();
        starter.resolveExtensions();
        starter.initFinished();
    }

    public void run(T configuration, Environment environment) throws Exception {
        GuiceyRunner runner = new GuiceyRunner(this.context, (Configuration)configuration, environment);
        runner.runBundles();
        runner.prepareModules();
        this.injector = runner.createInjector(this.injectorFactory, runner.analyzeAndRepackageBindings());
        runner.installExtensions();
        runner.injectCommands();
        runner.runFinished();
    }

    public Injector getInjector() {
        return (Injector)Preconditions.checkNotNull((Object)this.injector, (Object)"Guice not initialized");
    }

    public static <T extends Configuration> Builder<T> builder() {
        return new Builder().hookAlias("diagnostic", DiagnosticHook.class);
    }

    public static class Builder<T extends Configuration> {
        private final GuiceBundle<T> bundle = new GuiceBundle();

        public Builder<T> listen(GuiceyLifecycleListener ... listeners) {
            ((GuiceBundle)this.bundle).context.lifecycle().register(listeners);
            return this;
        }

        public <K extends Enum> Builder<T> option(K option, Object value) {
            ((GuiceBundle)this.bundle).context.setOption(option, value);
            return this;
        }

        public <K extends Enum> Builder<T> options(Map<Enum, Object> options) {
            options.forEach((x$0, x$1) -> this.option((Enum)x$0, x$1));
            return this;
        }

        public Builder<T> injectorFactory(InjectorFactory injectorFactory) {
            ((GuiceBundle)this.bundle).injectorFactory = injectorFactory;
            return this;
        }

        public Builder<T> bundleLookup(GuiceyBundleLookup bundleLookup) {
            ((GuiceBundle)this.bundle).bundleLookup = bundleLookup;
            return this;
        }

        public Builder<T> disableBundleLookup() {
            return this.bundleLookup(new VoidBundleLookup());
        }

        public Builder<T> enableAutoConfig(String ... basePackages) {
            Preconditions.checkState((basePackages.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one package to scan");
            return this.option(GuiceyOptions.ScanPackages, basePackages);
        }

        public Builder<T> duplicateConfigDetector(DuplicateConfigDetector detector) {
            ((GuiceBundle)this.bundle).context.setDuplicatesDetector(detector);
            return this;
        }

        public Builder<T> modules(Module ... modules) {
            Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
            ((GuiceBundle)this.bundle).context.registerModules(modules);
            return this;
        }

        public Builder<T> modulesOverride(Module ... modules) {
            ((GuiceBundle)this.bundle).context.registerModulesOverride(modules);
            return this;
        }

        public Builder<T> searchCommands() {
            return this.option(GuiceyOptions.SearchCommands, true);
        }

        public Builder<T> noDefaultInstallers() {
            return this.option(GuiceyOptions.UseCoreInstallers, false);
        }

        public Builder<T> noGuiceFilter() {
            return this.option(GuiceyOptions.GuiceFilterRegistration, EnumSet.noneOf(DispatcherType.class));
        }

        @SafeVarargs
        public final Builder<T> installers(Class<? extends FeatureInstaller> ... installers) {
            ((GuiceBundle)this.bundle).context.registerInstallers(installers);
            return this;
        }

        public Builder<T> extensions(Class<?> ... extensionClasses) {
            ((GuiceBundle)this.bundle).context.registerExtensions(extensionClasses);
            return this;
        }

        public Builder<T> bundles(GuiceyBundle ... bundles) {
            ((GuiceBundle)this.bundle).context.registerBundles(bundles);
            return this;
        }

        public Builder<T> dropwizardBundles(ConfiguredBundle ... bundles) {
            ((GuiceBundle)this.bundle).context.registerDropwizardBundles(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder<T> disableInstallers(Class<? extends FeatureInstaller> ... installers) {
            ((GuiceBundle)this.bundle).context.disableInstallers(installers);
            return this;
        }

        public final Builder<T> disableExtensions(Class<?> ... extensions) {
            ((GuiceBundle)this.bundle).context.disableExtensions(extensions);
            return this;
        }

        @SafeVarargs
        public final Builder<T> disableModules(Class<? extends Module> ... modules) {
            ((GuiceBundle)this.bundle).context.disableModules(modules);
            return this;
        }

        @SafeVarargs
        public final Builder<T> disableBundles(Class<? extends GuiceyBundle> ... bundles) {
            ((GuiceBundle)this.bundle).context.disableBundle(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder<T> disableDropwizardBundles(Class<? extends ConfiguredBundle> ... bundles) {
            ((GuiceBundle)this.bundle).context.disableDropwizardBundle(bundles);
            return this;
        }

        @SafeVarargs
        public final Builder<T> disable(Predicate<ItemInfo> ... predicates) {
            ((GuiceBundle)this.bundle).context.registerDisablePredicates(predicates);
            return this;
        }

        public Builder<T> strictScopeControl() {
            ((GuiceBundle)this.bundle).context.registerBundles(new HK2DebugBundle());
            return this;
        }

        public Builder<T> useHK2ForJerseyExtensions() {
            this.option(InstallersOptions.JerseyExtensionsManagedByGuice, false);
            this.option(GuiceyOptions.UseHkBridge, true);
            return this;
        }

        public Builder<T> printDiagnosticInfo() {
            return this.listen(new ConfigurationDiagnostic());
        }

        public Builder<T> printAvailableInstallers() {
            return this.listen(ConfigurationDiagnostic.builder("Available installers report").printConfiguration(new DiagnosticConfig().printInstallers().printNotUsedInstallers().printInstallerInterfaceMarkers()).printContextTree(new ContextTreeConfig().hideCommands().hideDuplicateRegistrations().hideEmptyBundles().hideExtensions().hideModules()).build());
        }

        public Builder<T> printConfigurationBindings() {
            return this.listen(new YamlBindingsDiagnostic());
        }

        public Builder<T> printCustomConfigurationBindings() {
            return this.listen(new YamlBindingsDiagnostic(new BindingsConfig().showConfigurationTree().showNullValues().showCustomConfigOnly()));
        }

        public Builder<T> printGuiceBindings() {
            return this.listen(new GuiceBindingsDiagnostic(new GuiceConfig().hideGuiceBindings().hideGuiceyBindings()));
        }

        public Builder<T> printAllGuiceBindings() {
            return this.listen(new GuiceBindingsDiagnostic(new GuiceConfig()));
        }

        public Builder<T> printGuiceAopMap() {
            return this.printGuiceAopMap(new GuiceAopConfig());
        }

        public Builder<T> printGuiceAopMap(GuiceAopConfig config) {
            return this.listen(new GuiceAopDiagnostic(config));
        }

        public Builder<T> printLifecyclePhases() {
            return this.listen(new LifecycleDiagnostic(false));
        }

        public Builder<T> printLifecyclePhasesDetailed() {
            return this.listen(new LifecycleDiagnostic(true));
        }

        public Builder<T> hookAlias(String name, Class<? extends GuiceyConfigurationHook> hook) {
            ConfigurationHooksSupport.registerSystemHookAlias(name, hook);
            return this;
        }

        public GuiceBundle<T> build(Stage stage) {
            this.option(GuiceyOptions.InjectorStage, stage);
            return this.build();
        }

        public GuiceBundle<T> build() {
            ((GuiceBundle)this.bundle).context.runHooks(this);
            return this.bundle;
        }
    }
}

