/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.debug.report.yaml.BindingsConfig;
import ru.vyarus.dropwizard.guice.debug.report.yaml.ConfigBindingsRenderer;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleAdapter;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BeforeRunEvent;

public class YamlBindingsDiagnostic
extends GuiceyLifecycleAdapter {
    private final Logger logger = LoggerFactory.getLogger(YamlBindingsDiagnostic.class);
    private final BindingsConfig config;

    public YamlBindingsDiagnostic() {
        this(new BindingsConfig().showConfigurationTree().showNullValues());
    }

    public YamlBindingsDiagnostic(BindingsConfig config) {
        this.config = config;
    }

    @Override
    protected void beforeRun(BeforeRunEvent event) {
        boolean customOnly = this.config.isShowCustomConfigOnly();
        String report = customOnly && event.getConfigurationTree().getRootTypes().size() == 1 ? Reporter.NEWLINE + Reporter.NEWLINE + "    " + "No custom bindings" : new ConfigBindingsRenderer(event.getConfigurationTree()).renderReport(this.config);
        this.logger.info("Available {}configuration bindings = {}", (Object)(customOnly ? "custom " : ""), (Object)report);
    }

    public boolean equals(Object obj) {
        return obj instanceof YamlBindingsDiagnostic;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

