/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.diagnostic;

import com.google.common.collect.Lists;
import com.google.inject.Module;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.cli.Command;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.report.diagnostic.DiagnosticConfig;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.info.BundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.CommandItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ExtensionItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.GuiceyBundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.InstallerItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.JerseyInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.TypeInstaller;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.option.WithOptions;
import ru.vyarus.dropwizard.guice.module.installer.order.Ordered;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class DiagnosticRenderer
implements ReportRenderer<DiagnosticConfig> {
    private static final int SINGLE = 1;
    private static final String DW = "DW";
    private static final String JERSEY = "JERSEY";
    private static final String BINDING = "BINDING";
    private final GuiceyConfigurationInfo service;

    public DiagnosticRenderer(GuiceyConfigurationInfo service) {
        this.service = service;
    }

    @Override
    public String renderReport(DiagnosticConfig config) {
        StringBuilder res = new StringBuilder();
        this.printCommands(config, res);
        this.printBundles(config, res);
        if (config.isPrintInstallers()) {
            this.printInstallers(config, res);
            this.printDisabledExtensions(config, res, true);
        } else {
            this.printExtensionsOnly(config, res);
        }
        this.printModules(config, res);
        return res.toString();
    }

    private void printCommands(DiagnosticConfig config, StringBuilder res) {
        List<Class<Command>> commands = this.service.getCommands();
        if (!config.isPrintCommands() || commands.isEmpty()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("COMMANDS = ").append(Reporter.NEWLINE);
        ArrayList markers = Lists.newArrayList();
        for (Class<Command> command : commands) {
            markers.clear();
            CommandItemInfo info = (CommandItemInfo)this.service.getInfo(command);
            this.commonMarkers(markers, info);
            if (info.isEnvironmentCommand()) {
                markers.add("GUICE_ENABLED");
            }
            res.append("    ").append("    ").append(RenderUtils.renderClassLine(command, markers)).append(Reporter.NEWLINE);
        }
    }

    private void printBundles(DiagnosticConfig config, StringBuilder res) {
        List<Class<Object>> bundles = this.service.getDirectBundles();
        if (!config.isPrintBundles() || bundles.isEmpty()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("BUNDLES = ").append(Reporter.NEWLINE);
        ArrayList<Class> rendered = new ArrayList<Class>(bundles);
        for (Class<Object> bundle : bundles) {
            this.renderBundleRecursive(res, bundle, 1, rendered);
        }
        if (config.isPrintDisabledItems()) {
            List<String> dwMarker = Collections.singletonList(DW);
            for (Class<Object> bundle : this.service.getBundlesDisabled()) {
                res.append("    ").append("    ").append(RenderUtils.renderDisabledClassLine(bundle, 0, ConfiguredBundle.class.isAssignableFrom(bundle) ? dwMarker : null)).append(Reporter.NEWLINE);
            }
        }
    }

    private void renderBundleRecursive(StringBuilder res, Class<Object> bundle, int level, List<Class> rendered) {
        BundleItemInfo info = (BundleItemInfo)this.service.getInfo(bundle);
        ArrayList markers = Lists.newArrayList();
        if (info.isDropwizard()) {
            markers.add(DW);
        } else if (((GuiceyBundleItemInfo)info).isFromLookup()) {
            markers.add("LOOKUP");
        }
        this.commonMarkers(markers, info);
        for (int i = 0; i <= level; ++i) {
            res.append("    ");
        }
        res.append(RenderUtils.renderClassLine(bundle, markers)).append(Reporter.NEWLINE);
        List<Class<Object>> bundles = this.service.getRelativelyInstalledBundles(bundle);
        rendered.add(bundle);
        for (Class<Object> relative : bundles) {
            if (rendered.contains(relative)) continue;
            this.renderBundleRecursive(res, relative, level + 1, rendered);
        }
    }

    private void printInstallers(DiagnosticConfig config, StringBuilder res) {
        List<Class<FeatureInstaller>> installers = this.service.getInstallersOrdered();
        if (installers.isEmpty()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("INSTALLERS ");
        if (config.isPrintExtensions()) {
            res.append("and EXTENSIONS ");
        }
        res.append("in processing order = ").append(Reporter.NEWLINE);
        this.renderInstallers(config, res, installers);
        if (config.isPrintDisabledItems()) {
            for (Class<FeatureInstaller> installer : this.service.getInstallersDisabled()) {
                res.append("    ").append("    ").append(RenderUtils.renderDisabledInstaller(installer)).append(Reporter.NEWLINE);
            }
        }
    }

    private void renderInstallers(DiagnosticConfig config, StringBuilder res, List<Class<FeatureInstaller>> installers) {
        ArrayList markers = Lists.newArrayList();
        for (Class<FeatureInstaller> installer : installers) {
            List<Class<Object>> extensions = this.service.getExtensionsOrdered(installer);
            if (extensions.isEmpty() && !config.isPrintNotUsedInstallers()) continue;
            InstallerItemInfo info = (InstallerItemInfo)this.service.getInfo(installer);
            markers.clear();
            this.commonMarkers(markers, info);
            String prefix = config.isPrintInstallerInterfaceMarkers() ? this.renderInstallerMarkers(installer) : "";
            res.append("    ").append("    ").append(prefix).append(RenderUtils.renderInstaller(installer, markers)).append(Reporter.NEWLINE);
            if (!config.isPrintExtensions()) continue;
            for (Class<Object> ext : extensions) {
                res.append("    ").append("    ").append("    ").append(this.renderExtension(ext)).append(Reporter.NEWLINE);
            }
        }
    }

    private void printExtensionsOnly(DiagnosticConfig config, StringBuilder res) {
        List<Class<Object>> extensions = this.service.getExtensions();
        if (!config.isPrintExtensions() || extensions.isEmpty()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("EXTENSIONS = ").append(Reporter.NEWLINE);
        for (Class<Object> ext : extensions) {
            res.append("    ").append("    ").append(this.renderExtension(ext)).append(Reporter.NEWLINE);
        }
        this.printDisabledExtensions(config, res, false);
    }

    private void printDisabledExtensions(DiagnosticConfig config, StringBuilder res, boolean section) {
        List<Class<Object>> extensions = this.service.getExtensionsDisabled();
        if (!config.isPrintExtensions() || !config.isPrintDisabledItems() || extensions.isEmpty()) {
            return;
        }
        if (section) {
            res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("DISABLED EXTENSIONS = ").append(Reporter.NEWLINE);
        }
        ArrayList<String> markers = new ArrayList<String>();
        for (Class<Object> ext : extensions) {
            ExtensionItemInfo einfo = (ExtensionItemInfo)this.service.getInfo(ext);
            if (einfo.isGuiceBinding()) {
                markers.add(BINDING);
            }
            res.append("    ").append("    ").append(RenderUtils.renderDisabledClassLine(ext, 0, markers)).append(Reporter.NEWLINE);
            markers.clear();
        }
    }

    private String renderExtension(Class<Object> extension) {
        ExtensionItemInfo einfo = (ExtensionItemInfo)this.service.getInfo(extension);
        ArrayList markers = Lists.newArrayList();
        this.commonMarkers(markers, einfo);
        if (einfo.isLazy()) {
            markers.add("LAZY");
        }
        if (einfo.isJerseyManaged()) {
            markers.add(JERSEY);
        }
        if (einfo.isGuiceBinding()) {
            markers.add(BINDING);
        }
        return RenderUtils.renderClassLine(extension, markers);
    }

    private void printModules(DiagnosticConfig config, StringBuilder res) {
        List<Class<Module>> modules = this.service.getModules();
        if (!config.isPrintModules() || modules.isEmpty()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("GUICE MODULES = ").append(Reporter.NEWLINE);
        ArrayList markers = Lists.newArrayList();
        for (Class<Module> module : modules) {
            markers.clear();
            ModuleItemInfo info = (ModuleItemInfo)this.service.getInfo(module);
            this.commonMarkers(markers, info);
            if (info.isOverriding()) {
                markers.add("OVERRIDE");
            }
            res.append("    ").append("    ").append(RenderUtils.renderClassLine(module, markers)).append(Reporter.NEWLINE);
        }
        if (config.isPrintDisabledItems()) {
            for (Class<Module> module : this.service.getModulesDisabled()) {
                res.append("    ").append("    ").append(RenderUtils.renderDisabledClassLine(module)).append(Reporter.NEWLINE);
            }
        }
    }

    private void commonMarkers(List<String> markers, ItemInfo item) {
        if (item.getRegisteredBy().contains(ConfigScope.ClasspathScan.getKey())) {
            markers.add("SCAN");
        }
        if (item.getRegisteredBy().contains(ConfigScope.Hook.getKey())) {
            markers.add("HOOK");
        }
        if (item.getItemType().isInstanceConfig()) {
            List allItems = this.service.getData().getInfos(item.getType());
            if (allItems.size() > 1 || allItems.size() == 1 && ((ItemInfo)allItems.get(0)).getRegistrationAttempts() > 1) {
                int registrations = 0;
                for (ItemInfo info : allItems) {
                    registrations += info.getRegistrationAttempts();
                }
                markers.add(this.formatReg(allItems.size(), registrations));
            }
        } else if (item.getRegistrationAttempts() > 1) {
            markers.add(this.formatReg(1, item.getRegistrationAttempts()));
        }
    }

    private String formatReg(int used, int registered) {
        return String.format("REG(%s/%s)", used, registered);
    }

    private String renderInstallerMarkers(Class type) {
        ArrayList<String> markers = new ArrayList<String>();
        if (TypeInstaller.class.isAssignableFrom(type)) {
            markers.add("TYPE");
        }
        if (InstanceInstaller.class.isAssignableFrom(type)) {
            markers.add("OBJECT");
        }
        if (JerseyInstaller.class.isAssignableFrom(type)) {
            markers.add(JERSEY);
        }
        if (BindingInstaller.class.isAssignableFrom(type)) {
            markers.add("BIND");
        }
        if (WithOptions.class.isAssignableFrom(type)) {
            markers.add("OPTIONS");
        }
        if (Ordered.class.isAssignableFrom(type)) {
            markers.add("ORDER");
        }
        return String.format("%-30s ", String.join((CharSequence)", ", markers));
    }
}

