/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice;

import com.google.inject.matcher.Matcher;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.NonObjectMethodMatcher;

public class GuiceAopConfig {
    private boolean hideDeclarations;
    private Matcher<? super Class<?>> typeMatcher;
    private Matcher<? super Method> methodMatcher = new NonObjectMethodMatcher();
    private final Set<Class<? extends MethodInterceptor>> showOnly = new HashSet<Class<? extends MethodInterceptor>>();

    public GuiceAopConfig hideDeclarationsBlock() {
        this.hideDeclarations = true;
        return this;
    }

    public GuiceAopConfig types(Matcher<? super Class<?>> matcher) {
        this.typeMatcher = matcher;
        return this;
    }

    public GuiceAopConfig methods(Matcher<? super Method> matcher) {
        this.methodMatcher = matcher;
        return this;
    }

    @SafeVarargs
    public final GuiceAopConfig interceptors(Class<? extends MethodInterceptor> ... interceptors) {
        Collections.addAll(this.showOnly, interceptors);
        return this;
    }

    public boolean isHideDeclarationsBlock() {
        return this.hideDeclarations;
    }

    public Matcher<? super Class<?>> getTypeMatcher() {
        return this.typeMatcher;
    }

    public Matcher<? super Method> getMethodMatcher() {
        return this.methodMatcher;
    }

    public Set<Class<? extends MethodInterceptor>> getShowOnly() {
        return this.showOnly;
    }
}

