/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceConfig;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.BindingDeclaration;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.DeclarationType;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.ModuleDeclaration;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelParser;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelUtils;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.debug.util.TreeNode;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class GuiceBindingsRenderer
implements ReportRenderer<GuiceConfig> {
    private final Injector injector;
    private final List<Module> modules;
    private final List<Module> overridden;
    private final List<Class<Object>> extensions;
    private final List<Class<Object>> disabled;

    public GuiceBindingsRenderer(Injector injector) {
        this.injector = injector;
        GuiceyConfigurationInfo info = (GuiceyConfigurationInfo)injector.getInstance(GuiceyConfigurationInfo.class);
        this.modules = info.getNormalModules().stream().map(it -> (Module)((ModuleItemInfo)info.getInfo((Class<?>)it)).getInstance()).collect(Collectors.toList());
        this.overridden = info.getOverridingModules().stream().map(it -> (Module)((ModuleItemInfo)info.getInfo((Class<?>)it)).getInstance()).collect(Collectors.toList());
        this.extensions = ItemId.typesOnly(info.getData().getItems(ConfigItem.Extension));
        this.disabled = info.getExtensionsDisabled();
    }

    @Override
    public String renderReport(GuiceConfig config) {
        List<ModuleDeclaration> moduleItems = this.filter(GuiceModelParser.parse(this.injector, Elements.getElements((Stage)Stage.TOOL, this.modules)), config);
        Map<Key, BindingDeclaration> moduleBindings = GuiceModelUtils.index(moduleItems);
        this.markExtensions(moduleBindings);
        List<ModuleDeclaration> overrideItems = this.filter(this.overridden.isEmpty() ? Collections.emptyList() : GuiceModelParser.parse(this.injector, Elements.getElements((Stage)Stage.TOOL, this.overridden)), config);
        Map<Key, BindingDeclaration> overrideBindings = GuiceModelUtils.index(overrideItems);
        this.markOverrides(moduleBindings, overrideBindings);
        StringBuilder res = new StringBuilder();
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE);
        this.renderModules(res, moduleItems, moduleBindings);
        this.renderOverrides(res, overrideItems, overrideBindings);
        moduleBindings.putAll(overrideBindings);
        this.renderJitBindings(res, moduleBindings, config, this.extensions);
        this.renderBindingChains(res, moduleBindings);
        return res.toString();
    }

    private void renderModules(StringBuilder res, List<ModuleDeclaration> moduleItems, Map<Key, BindingDeclaration> moduleBindings) {
        TreeNode root = new TreeNode("%s MODULES with %s bindings", GuiceModelUtils.getModules(moduleItems).size(), moduleBindings.size());
        for (ModuleDeclaration mod : moduleItems) {
            this.render(root, mod);
        }
        root.render(res);
    }

    private void renderOverrides(StringBuilder res, List<ModuleDeclaration> overrideItems, Map<Key, BindingDeclaration> overrideBindings) {
        if (!overrideItems.isEmpty()) {
            TreeNode root = new TreeNode("%s OVERRIDING MODULES with %s bindings", GuiceModelUtils.getModules(overrideItems).size(), overrideBindings.size());
            for (ModuleDeclaration mod : overrideItems) {
                this.render(root, mod);
            }
            if (root.hasChildren()) {
                res.append(Reporter.NEWLINE).append(Reporter.NEWLINE);
                root.render(res);
            }
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    private void renderJitBindings(StringBuilder res, Map<Key, BindingDeclaration> moduleBindings, GuiceConfig config, List<Class<Object>> extensions) {
        List<ModuleDeclaration> jits;
        HashMap jitBindings = new HashMap(this.injector.getAllBindings());
        for (Key key2 : this.injector.getBindings().keySet()) {
            jitBindings.remove(key2);
        }
        for (BindingDeclaration dec : moduleBindings.values()) {
            if (dec.getKey() != null) {
                jitBindings.remove(dec.getKey());
            }
            if (dec.getTarget() == null) continue;
            jitBindings.remove(dec.getTarget());
        }
        jitBindings.keySet().removeIf(key -> extensions.contains(key.getTypeLiteral().getRawType()));
        if (!jitBindings.isEmpty() && !(jits = this.filter(GuiceModelParser.parse(this.injector, jitBindings.values()), config)).isEmpty()) {
            Preconditions.checkState((jits.size() == 1 ? 1 : 0) != 0, (String)"One module expected, but got %s", (int)jits.size());
            List<BindingDeclaration> declarations = jits.get(0).getDeclarations();
            TreeNode root = new TreeNode("%s UNDECLARED bindings", declarations.size());
            for (BindingDeclaration dec : declarations) {
                if (dec.getKey() != null) {
                    moduleBindings.put(dec.getKey(), dec);
                }
                root.child(String.format("%-28s %-26s", this.renderElement(dec), RenderUtils.brackets(RenderUtils.renderPackage(dec.getKey().getTypeLiteral().getRawType()))), new Object[0]);
            }
            if (root.hasChildren()) {
                res.append(Reporter.NEWLINE).append(Reporter.NEWLINE);
                root.render(res);
            }
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    private void renderBindingChains(StringBuilder res, Map<Key, BindingDeclaration> bindings) {
        ArrayList<BindingDeclaration> chains = new ArrayList<BindingDeclaration>();
        ArrayList<Key> targetKeys = new ArrayList<Key>();
        for (BindingDeclaration dec : bindings.values()) {
            if (dec.getKey() != null && this.disabled.contains(dec.getKey().getTypeLiteral().getRawType()) || dec.getTarget() == null) continue;
            chains.add(dec);
            if (dec.getTarget() == null) continue;
            targetKeys.add(dec.getTarget());
        }
        chains.removeIf(it -> targetKeys.contains(it.getKey()));
        List<String> lines = this.renderChainLines(chains, bindings);
        if (!lines.isEmpty()) {
            lines.sort(Comparator.naturalOrder());
            TreeNode root = new TreeNode("BINDING CHAINS", chains.size());
            for (String line : lines) {
                root.child(line, new Object[0]);
            }
            res.append(Reporter.NEWLINE).append(Reporter.NEWLINE);
            root.render(res);
        }
    }

    private List<ModuleDeclaration> filter(List<ModuleDeclaration> modules, GuiceConfig config) {
        modules.removeIf(it -> config.getIgnoreModules().contains(it.getType()) || !it.isJITBindings() && this.filter(it.getType().getName(), config.getIgnorePackages()));
        for (ModuleDeclaration mod : modules) {
            mod.getDeclarations().removeIf(it -> it.getKey() != null && this.filter(it.getKey().getTypeLiteral().getRawType().getName(), config.getIgnorePackages()));
            this.filter(mod.getChildren(), config);
        }
        return modules;
    }

    private boolean filter(String type, List<String> pkgs) {
        for (String pkg : pkgs) {
            if (!type.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    private void markOverrides(Map<Key, BindingDeclaration> moduleBindings, Map<Key, BindingDeclaration> overrideBindings) {
        if (!overrideBindings.isEmpty()) {
            for (Map.Entry<Key, BindingDeclaration> entry : overrideBindings.entrySet()) {
                Key key = entry.getKey();
                BindingDeclaration dec = moduleBindings.get(key);
                if (dec == null) continue;
                dec.getMarkers().add("OVERRIDDEN");
                entry.getValue().getMarkers().add("OVERRIDE");
            }
        }
    }

    private void markExtensions(Map<Key, BindingDeclaration> moduleBindings) {
        for (BindingDeclaration dec : moduleBindings.values()) {
            if (!this.extensions.contains(dec.getKey().getTypeLiteral().getRawType())) continue;
            dec.getMarkers().add("EXTENSION");
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    private void render(TreeNode root, ModuleDeclaration mod) {
        TreeNode next = root.child(RenderUtils.renderClassLine(mod.getType(), mod.getMarkers()), new Object[0]);
        for (BindingDeclaration dec : mod.getDeclarations()) {
            if (dec.getKey() != null && this.disabled.contains(dec.getKey().getTypeLiteral().getRawType())) {
                dec.getMarkers().add("REMOVED");
            }
            String type = dec.getType().isRuntimeBinding() ? dec.getType().name().toLowerCase() : "<" + dec.getType().name().toLowerCase() + ">";
            StringBuilder msg = new StringBuilder(String.format("%-20s %-16s %-45s", type, dec.getScope() != null ? "[@" + dec.getScope().getSimpleName() + "]" : "", this.renderElement(dec)));
            msg.append("   at ").append(dec.getSource());
            if (!dec.getMarkers().isEmpty()) {
                msg.append(' ').append(RenderUtils.markers(dec.getMarkers()));
            }
            next.child(msg.toString(), new Object[0]);
        }
        for (ModuleDeclaration child : mod.getChildren()) {
            this.render(next, child);
        }
    }

    private String renderElement(BindingDeclaration declaration) {
        String res;
        if (declaration.getKey() == null && declaration.getSpecial() != null) {
            res = declaration.getSpecial().stream().map(it -> RenderUtils.getClassName(it.getClass())).collect(Collectors.joining(","));
        } else {
            res = GuiceModelUtils.renderKey(declaration.getKey());
            if (declaration.getSpecial() != null) {
                res = res + " (" + declaration.getSpecial().stream().map(Object::toString).collect(Collectors.joining(", ")) + ")";
            }
        }
        return res;
    }

    private List<String> renderChainLines(List<BindingDeclaration> roots, Map<Key, BindingDeclaration> bindings) {
        ArrayList<String> lines = new ArrayList<String>();
        for (BindingDeclaration dec : roots) {
            StringBuilder line = new StringBuilder(GuiceModelUtils.renderKey(dec.getKey()));
            BindingDeclaration curr = dec;
            while (curr != null && (curr.getTarget() != null || curr.getProvidedBy() != null)) {
                Key link = curr.getTarget();
                if (link != null) {
                    String tag = curr.getType().equals((Object)DeclarationType.ConvertedConstant) ? "converted" : "linked";
                    line.append("  --[").append(tag).append("]-->  ").append(GuiceModelUtils.renderKey(link));
                } else {
                    line.append("  --[provided]-->  ").append(curr.getProvidedBy());
                }
                BindingDeclaration nextDec = null;
                if (link != null && (nextDec = bindings.get(link)) == null) {
                    nextDec = GuiceModelParser.parseElement(this.injector, (Element)this.injector.getExistingBinding(link));
                }
                curr = nextDec;
            }
            lines.add(line.toString());
        }
        return lines;
    }
}

