/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice.util.visitor;

import com.google.inject.Key;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.InstanceFilterBinding;
import com.google.inject.servlet.InstanceServletBinding;
import com.google.inject.servlet.LinkedFilterBinding;
import com.google.inject.servlet.LinkedServletBinding;
import com.google.inject.servlet.ServletModuleTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.util.Collections;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.BindingDeclaration;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.DeclarationType;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelUtils;

public class GuiceBindingVisitor
implements ServletModuleTargetVisitor<Object, BindingDeclaration> {
    public BindingDeclaration visit(InstanceBinding binding) {
        Class annotationType = binding.getKey().getAnnotationType();
        if (annotationType != null && annotationType.getDeclaringClass() != null && annotationType.getDeclaringClass().equals(UniqueAnnotations.class)) {
            return null;
        }
        BindingDeclaration res = new BindingDeclaration(DeclarationType.Instance, binding);
        res.setKey(binding.getKey());
        return res;
    }

    public BindingDeclaration visit(ProviderInstanceBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.ProviderInstance, binding);
        res.setKey(binding.getKey());
        res.setProvidedBy(binding.getUserSuppliedProvider().toString());
        return res;
    }

    public BindingDeclaration visit(ProviderKeyBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.ProviderKey, binding);
        res.setKey(binding.getKey());
        res.setProvidedBy(GuiceModelUtils.renderKey(binding.getProviderKey()));
        return res;
    }

    public BindingDeclaration visit(LinkedKeyBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.LinkedKey, binding);
        res.setKey(binding.getKey());
        res.setTarget(binding.getLinkedKey());
        return res;
    }

    public BindingDeclaration visit(ExposedBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.Exposed, binding);
        res.setKey(binding.getKey());
        return res;
    }

    public BindingDeclaration visit(UntargettedBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.Untargetted, binding);
        res.setKey(binding.getKey());
        return res;
    }

    public BindingDeclaration visit(ConstructorBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.Binding, binding);
        res.setKey(binding.getKey());
        return res;
    }

    public BindingDeclaration visit(ConvertedConstantBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.ConvertedConstant, binding);
        res.setKey(binding.getKey());
        res.setTarget(binding.getSourceKey());
        res.setSpecial(Collections.singletonList("converted by " + binding.getTypeConverterBinding().getTypeConverter().getClass().getName()));
        return res;
    }

    public BindingDeclaration visit(ProviderBinding binding) {
        return null;
    }

    public BindingDeclaration visit(LinkedFilterBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.FilterKey, binding);
        res.setKey(binding.getLinkedKey());
        res.setSpecial(Collections.singletonList(binding.getPattern()));
        return res;
    }

    public BindingDeclaration visit(InstanceFilterBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.FilterInstance, binding);
        res.setKey(Key.get(binding.getFilterInstance().getClass()));
        res.setSpecial(Collections.singletonList(binding.getPattern()));
        return res;
    }

    public BindingDeclaration visit(LinkedServletBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.ServletKey, binding);
        res.setKey(binding.getLinkedKey());
        res.setSpecial(Collections.singletonList(binding.getPattern()));
        return res;
    }

    public BindingDeclaration visit(InstanceServletBinding binding) {
        BindingDeclaration res = new BindingDeclaration(DeclarationType.ServletInstance, binding);
        res.setKey(Key.get(binding.getServletInstance().getClass()));
        res.setSpecial(Collections.singletonList(binding.getPattern()));
        return res;
    }
}

