/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.hook;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.installer.util.PropertyUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public final class ConfigurationHooksSupport {
    public static final String HOOKS_PROPERTY = "guicey.hooks";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationHooksSupport.class);
    private static final ThreadLocal<Set<GuiceyConfigurationHook>> HOOKS = new ThreadLocal();
    private static final ThreadLocal<Map<String, String>> ALIASES = new ThreadLocal();

    private ConfigurationHooksSupport() {
    }

    public static void register(GuiceyConfigurationHook hook) {
        if (HOOKS.get() == null) {
            HOOKS.set(new LinkedHashSet());
        }
        HOOKS.get().add(hook);
    }

    public static void registerSystemHookAlias(String alias, Class<?> hook) {
        Map<String, String> aliases = ALIASES.get();
        if (aliases == null) {
            aliases = new HashMap<String, String>();
            ALIASES.set(aliases);
        }
        Preconditions.checkState((!aliases.containsKey(alias) ? 1 : 0) != 0, (String)"Can't register alias '%s' for hook %s because it's already registered for hook %s", (Object)alias, hook, (Object)aliases.get(alias));
        aliases.put(alias, hook.getName());
    }

    public static Map<String, String> getSystemHookAliases() {
        return ALIASES.get() != null ? ALIASES.get() : Collections.emptyMap();
    }

    public static void logRegisteredAliases() {
        if (!ConfigurationHooksSupport.getSystemHookAliases().isEmpty()) {
            StringBuilder res = new StringBuilder().append(Reporter.NEWLINE).append(Reporter.NEWLINE);
            for (Map.Entry<String, String> entry : ConfigurationHooksSupport.getSystemHookAliases().entrySet()) {
                res.append("    ").append(String.format("%-30s", entry.getKey())).append(entry.getValue()).append(Reporter.NEWLINE);
            }
            LOGGER.info("Available hook aliases [ -D{}=alias ]: {}", (Object)HOOKS_PROPERTY, (Object)res.toString());
        }
    }

    public static void loadSystemHooks() {
        List<GuiceyConfigurationHook> hooks = PropertyUtils.getProperty(HOOKS_PROPERTY, ConfigurationHooksSupport.getSystemHookAliases());
        hooks.forEach(ConfigurationHooksSupport::register);
    }

    public static void reset() {
        HOOKS.remove();
        ALIASES.remove();
        System.clearProperty(HOOKS_PROPERTY);
    }

    public static Set<GuiceyConfigurationHook> run(GuiceBundle.Builder builder) {
        Set<GuiceyConfigurationHook> hooks = HOOKS.get();
        if (hooks != null) {
            hooks.forEach(l -> l.configure(builder));
        }
        ConfigurationHooksSupport.reset();
        return hooks;
    }

    public static int count() {
        return HOOKS.get() != null ? HOOKS.get().size() : 0;
    }
}

