/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.injector.lookup;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import io.dropwizard.Application;
import io.dropwizard.lifecycle.Managed;
import java.util.Map;
import java.util.Optional;

public final class InjectorLookup {
    private static final Map<Application, Injector> INJECTORS = Maps.newConcurrentMap();

    private InjectorLookup() {
    }

    public static Managed registerInjector(final Application application, Injector injector) {
        Preconditions.checkNotNull((Object)application, (Object)"Application instance required");
        Preconditions.checkArgument((!INJECTORS.containsKey(application) ? 1 : 0) != 0, (String)"Injector already registered for application %s", (Object)application.getClass().getName());
        INJECTORS.put(application, injector);
        return new Managed(){

            public void start() throws Exception {
            }

            public void stop() throws Exception {
                INJECTORS.remove(application);
            }
        };
    }

    public static Optional<Injector> getInjector(Application application) {
        return Optional.ofNullable(INJECTORS.get(application));
    }

    public static void clear() {
        INJECTORS.clear();
    }
}

