/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.info.impl;

import com.google.common.collect.Sets;
import com.google.inject.Binding;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.info.ExtensionItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ClassItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;

public class ExtensionItemInfoImpl
extends ClassItemInfoImpl
implements ExtensionItemInfo {
    private Class<? extends FeatureInstaller> installedBy;
    private boolean lazy;
    private boolean jerseyManaged;
    private Binding manualBinding;
    private final Set<ItemId> disabledBy = Sets.newLinkedHashSet();
    private FeatureInstaller installer;

    public ExtensionItemInfoImpl(Class<?> type) {
        super(ConfigItem.Extension, type);
    }

    @Override
    public Set<ItemId> getDisabledBy() {
        return this.disabledBy;
    }

    @Override
    public boolean isEnabled() {
        return this.disabledBy.isEmpty();
    }

    @Override
    public Class<? extends FeatureInstaller> getInstalledBy() {
        return this.installedBy;
    }

    @Override
    public boolean isFromScan() {
        return this.getRegisteredBy().contains(ConfigScope.ClasspathScan.getKey());
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public boolean isJerseyManaged() {
        return this.jerseyManaged;
    }

    @Override
    public boolean isGuiceBinding() {
        return this.manualBinding != null;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setJerseyManaged(boolean jerseyManaged) {
        this.jerseyManaged = jerseyManaged;
    }

    public void setManualBinding(Binding manualBinding) {
        this.manualBinding = manualBinding;
    }

    public Binding getManualBinding() {
        return this.manualBinding;
    }

    public FeatureInstaller getInstaller() {
        return this.installer;
    }

    public void setInstaller(FeatureInstaller installer) {
        this.installer = installer;
        this.installedBy = installer.getClass();
    }
}

