/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.info.impl;

import com.google.common.collect.Sets;
import com.google.inject.Module;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ModuleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.impl.InstanceItemInfoImpl;

public class ModuleItemInfoImpl
extends InstanceItemInfoImpl
implements ModuleItemInfo {
    private static ThreadLocal<Boolean> override = new ThreadLocal();
    private final Set<ItemId> disabledBy = Sets.newLinkedHashSet();
    private final boolean overriding;

    public ModuleItemInfoImpl(Class<? extends Module> type) {
        super(ConfigItem.Module, type);
        this.overriding = false;
    }

    public ModuleItemInfoImpl(Module module) {
        super(ConfigItem.Module, module);
        this.overriding = override.get() != null;
    }

    @Override
    public Set<ItemId> getDisabledBy() {
        return this.disabledBy;
    }

    @Override
    public boolean isEnabled() {
        return this.disabledBy.isEmpty();
    }

    @Override
    public boolean isOverriding() {
        return this.overriding;
    }

    public static void overrideScope(Runnable action) {
        override.set(true);
        try {
            action.run();
        }
        finally {
            override.remove();
        }
    }
}

