/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.bundle;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Environment;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public class GuiceyEnvironment {
    private final ConfigurationContext context;

    public GuiceyEnvironment(ConfigurationContext context) {
        this.context = context;
    }

    public <T extends Configuration> T configuration() {
        return (T)this.context.getConfiguration();
    }

    public <T> T configuration(String yamlPath) {
        return this.configurationTree().valueByPath(yamlPath);
    }

    public <T, K extends T> K configuration(Class<T> type) {
        return this.configurationTree().valueByUniqueDeclaredType(type);
    }

    public <T> List<? extends T> configurations(Class<T> type) {
        return this.configurationTree().valuesByType(type);
    }

    public ConfigurationTree configurationTree() {
        return this.context.getConfigurationTree();
    }

    public Environment environment() {
        return this.context.getEnvironment();
    }

    public Application application() {
        return this.context.getBootstrap().getApplication();
    }

    public <V, T extends Enum> V option(T option) {
        return this.context.option(option);
    }

    public GuiceyEnvironment modules(Module ... modules) {
        Preconditions.checkState((modules.length > 0 ? 1 : 0) != 0, (Object)"Specify at least one module");
        this.context.registerModules(modules);
        return this;
    }

    public GuiceyEnvironment modulesOverride(Module ... modules) {
        this.context.registerModulesOverride(modules);
        return this;
    }

    public final GuiceyEnvironment disableExtensions(Class<?> ... extensions) {
        this.context.disableExtensions(extensions);
        return this;
    }

    @SafeVarargs
    public final GuiceyEnvironment disableModules(Class<? extends Module> ... modules) {
        this.context.disableModules(modules);
        return this;
    }

    public GuiceyEnvironment register(Object ... items) {
        for (Object item : items) {
            this.environment().jersey().register(item);
        }
        return this;
    }

    public GuiceyEnvironment register(Class<?> ... items) {
        for (Class<?> item : items) {
            this.environment().jersey().register(item);
        }
        return this;
    }
}

