/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.eager;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Stage;
import com.google.inject.spi.BindingScopingVisitor;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Singleton;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.visitor.GuiceScopingVisitor;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.eager.EagerSingleton;
import ru.vyarus.dropwizard.guice.module.installer.install.binding.BindingInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.util.BindingUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Order(value=50)
public class EagerSingletonInstaller
implements FeatureInstaller<Object>,
BindingInstaller {
    private static final GuiceScopingVisitor VISITOR = new GuiceScopingVisitor();
    private final Reporter reporter = new Reporter(EagerSingletonInstaller.class, "eager singletons =");
    private final Set<String> prerender = new LinkedHashSet<String>();

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.hasAnnotation(type, EagerSingleton.class);
    }

    @Override
    public void bindExtension(Binder binder, Class<?> type, boolean lazy) {
        Preconditions.checkArgument((!lazy ? 1 : 0) != 0, (String)"Eager bean can't be annotated as lazy: %s", (Object)type.getName());
        binder.bind(type).asEagerSingleton();
    }

    @Override
    public <T> void checkBinding(Binder binder, Class<T> type, Binding<T> manualBinding) {
        Class scope = (Class)manualBinding.acceptScopingVisitor((BindingScopingVisitor)VISITOR);
        Preconditions.checkArgument((scope.equals(EagerSingleton.class) || !binder.currentStage().equals((Object)Stage.DEVELOPMENT) && scope.equals(Singleton.class) ? 1 : 0) != 0, (String)"Eager bean, declared manually is not marked .asEagerSingleton(): %s (%s)", (Object)type.getName(), (Object)BindingUtils.getDeclarationSource(manualBinding));
    }

    @Override
    public void installBinding(Binder binder, Class<?> type) {
        this.prerender.add(String.format("(%s)", type.getName()));
    }

    @Override
    public void report() {
        for (String line : this.prerender) {
            this.reporter.line(line, new Object[0]);
        }
        this.prerender.clear();
        this.reporter.report();
    }
}

