/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.health;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.setup.Environment;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.health.NamedHealthCheck;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Order(value=60)
public class HealthCheckInstaller
implements FeatureInstaller<NamedHealthCheck>,
InstanceInstaller<NamedHealthCheck> {
    private final Reporter reporter = new Reporter(HealthCheckInstaller.class, "health checks =");

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.is(type, NamedHealthCheck.class);
    }

    @Override
    public void install(Environment environment, NamedHealthCheck instance) {
        environment.healthChecks().register(instance.getName(), (HealthCheck)instance);
        this.reporter.line("%-10s (%s)", instance.getName(), FeatureUtils.getInstanceClass(instance).getName());
    }

    @Override
    public void report() {
        this.reporter.report();
    }
}

