/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.jersey.provider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;
import ru.vyarus.dropwizard.guice.module.installer.feature.jersey.provider.JerseyProviderInstaller;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.java.generics.resolver.GenericsResolver;
import ru.vyarus.java.generics.resolver.context.GenericsContext;

public class ProviderReporter
extends Reporter {
    private static final String SIMPLE_FORMAT = "    (%s)";
    private static final String SINGLE_GENERIC_FORMAT = "    %-10s (%s)";
    private static final String DOUBLE_GENERICS_FORMAT = "    %-10s -> %-10s (%s)";
    private static final String INJECTION_FORMAT = "    @%-10s (%s)";
    private static final String JERSEY_MANAGED = " *jersey managed";
    private static final Map<Class, ExtDescriptor> DESCRIPTORS = ImmutableMap.builder().put(Supplier.class, (Object)new ExtDescriptor("Suppliers", "    %-10s (%s)", 1)).put(Function.class, (Object)new ExtDescriptor("Functions", "    %-10s -> %-10s (%s)", 2)).put(ExceptionMapper.class, (Object)new ExtDescriptor("Exception mappers", "    %-10s (%s)", 1)).put(ParamConverterProvider.class, (Object)new ExtDescriptor("Param converters", "    (%s)", 0)).put(ContextResolver.class, (Object)new ExtDescriptor("Context resolvers", "    %-10s (%s)", 1)).put(MessageBodyReader.class, (Object)new ExtDescriptor("Message body readers", "    %-10s (%s)", 1)).put(MessageBodyWriter.class, (Object)new ExtDescriptor("Message body writers", "    %-10s (%s)", 1)).put(ReaderInterceptor.class, (Object)new ExtDescriptor("Reader interceptors", "    (%s)", 0)).put(WriterInterceptor.class, (Object)new ExtDescriptor("Writer interceptors", "    (%s)", 0)).put(ContainerRequestFilter.class, (Object)new ExtDescriptor("Container request filters", "    (%s)", 0)).put(ContainerResponseFilter.class, (Object)new ExtDescriptor("Container response filters", "    (%s)", 0)).put(DynamicFeature.class, (Object)new ExtDescriptor("Dynamic features", "    (%s)", 0)).put(ValueParamProvider.class, (Object)new ExtDescriptor("Value factory providers", "    (%s)", 0)).put(InjectionResolver.class, (Object)new ExtDescriptor("Injection resolvers", "    @%-10s (%s)", 1)).put(ApplicationEventListener.class, (Object)new ExtDescriptor("Application event listeners", "    (%s)", 0)).build();
    private final Multimap<Class, String> prerender = HashMultimap.create();

    public ProviderReporter() {
        super(JerseyProviderInstaller.class, "providers = ");
    }

    public ProviderReporter provider(Class<?> provider, boolean isHkManaged, boolean isLazy) {
        boolean recognized = false;
        for (Map.Entry<Class, ExtDescriptor> entry : DESCRIPTORS.entrySet()) {
            Class ext = entry.getKey();
            if (!ext.isAssignableFrom(provider)) continue;
            recognized = true;
            this.prerender.put((Object)ext, (Object)this.renderLine(ext, provider, entry.getValue(), isHkManaged, isLazy));
        }
        if (!recognized) {
            this.prerender.put(Object.class, (Object)(String.format(SIMPLE_FORMAT, provider.getName()) + this.hkManaged(isHkManaged) + this.lazy(isLazy)));
        }
        return this;
    }

    @Override
    public void report() {
        for (Class cls : this.prerender.keySet()) {
            ExtDescriptor desc = DESCRIPTORS.get(cls);
            this.reportGroup(desc != null ? desc.name : "Other", this.prerender.get((Object)cls));
        }
        super.report();
    }

    private String renderLine(Class ext, Class provider, ExtDescriptor desc, boolean isHkManaged, boolean isLazy) {
        Object[] params = new Object[1 + desc.generics];
        int pos = 0;
        GenericsContext generics = GenericsResolver.resolve((Class)provider, (Class[])new Class[0]).type(ext);
        while (pos < desc.generics) {
            params[pos] = generics.genericAsString(pos++);
        }
        params[pos] = provider.getName();
        return String.format(desc.format, params) + this.hkManaged(isHkManaged) + this.lazy(isLazy);
    }

    private String hkManaged(boolean isHkManaged) {
        return isHkManaged ? JERSEY_MANAGED : "";
    }

    private void printAll(Collection<String> lines) {
        for (String line : lines) {
            this.line(line, new Object[0]);
        }
    }

    private void reportGroup(String title, Collection<String> items) {
        if (!items.isEmpty()) {
            this.separate();
            this.line(title, new Object[0]);
            this.printAll(items);
        }
    }

    private static class ExtDescriptor {
        public String name;
        public String format;
        public int generics;

        ExtDescriptor(String name, String format, int generics) {
            this.name = name;
            this.format = format;
            this.generics = generics;
        }
    }
}

