/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.web.util;

import com.google.common.base.Strings;
import javax.servlet.Filter;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import ru.vyarus.dropwizard.guice.module.installer.feature.web.AdminContext;

public final class WebUtils {
    private WebUtils() {
    }

    public static String getFilterName(WebFilter filter, Class<? extends Filter> type) {
        String name = Strings.emptyToNull((String)filter.filterName());
        return name != null ? name : WebUtils.generateName(type, "filter");
    }

    public static String getServletName(WebServlet servlet, Class<? extends HttpServlet> type) {
        String name = Strings.emptyToNull((String)servlet.name());
        return name != null ? name : WebUtils.generateName(type, "servlet");
    }

    public static boolean isForMain(AdminContext context) {
        return context == null || context.andMain();
    }

    public static boolean isForAdmin(AdminContext context) {
        return context != null;
    }

    public static String getContextMarkers(AdminContext context) {
        String res = "";
        if (WebUtils.isForAdmin(context)) {
            if (WebUtils.isForMain(context)) {
                res = res + "M";
            }
            res = res + "A";
        }
        return res;
    }

    public static String getAsyncMarker(WebFilter annotation) {
        return WebUtils.getAsyncMarker(annotation.asyncSupported());
    }

    public static String getAsyncMarker(WebServlet annotation) {
        return WebUtils.getAsyncMarker(annotation.asyncSupported());
    }

    private static String getAsyncMarker(boolean async) {
        return async ? "async" : "";
    }

    private static String generateName(Class<?> type, String keyword) {
        String probe = '.' + type.getSimpleName().toLowerCase();
        int targetLength = probe.length() - keyword.length();
        if (probe.endsWith(keyword) && targetLength > 2) {
            probe = probe.substring(0, targetLength);
        }
        return probe;
    }
}

