/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.common.base.Stopwatch;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.module.GuiceBootstrapModule;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.installer.internal.ExtensionsSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.BindingUtils;
import ru.vyarus.dropwizard.guice.module.support.BootstrapAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationTreeAwareModule;
import ru.vyarus.dropwizard.guice.module.support.EnvironmentAwareModule;
import ru.vyarus.dropwizard.guice.module.support.OptionsAwareModule;

public final class ModulesSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModulesSupport.class);

    private ModulesSupport() {
    }

    public static void configureModules(ConfigurationContext context) {
        Options options = new Options(context.options());
        for (Module mod : context.getEnabledModules()) {
            if (mod instanceof BootstrapAwareModule) {
                ((BootstrapAwareModule)mod).setBootstrap(context.getBootstrap());
            }
            if (mod instanceof ConfigurationAwareModule) {
                ((ConfigurationAwareModule)mod).setConfiguration(context.getConfiguration());
            }
            if (mod instanceof ConfigurationTreeAwareModule) {
                ((ConfigurationTreeAwareModule)mod).setConfigurationTree(context.getConfigurationTree());
            }
            if (mod instanceof EnvironmentAwareModule) {
                ((EnvironmentAwareModule)mod).setEnvironment(context.getEnvironment());
            }
            if (!(mod instanceof OptionsAwareModule)) continue;
            ((OptionsAwareModule)mod).setOptions(options);
        }
    }

    public static Iterable<Module> prepareModules(ConfigurationContext context) {
        Stopwatch timer = context.stat().timer(Stat.ModulesProcessingTime);
        List<Module> overridingModules = context.getOverridingModules();
        List<Module> normalModules = ModulesSupport.analyzeModules(context, timer);
        List<Module> res = overridingModules.isEmpty() ? normalModules : Collections.singletonList(Modules.override(normalModules).with(overridingModules));
        timer.stop();
        return res;
    }

    private static List<Module> analyzeModules(ConfigurationContext context, Stopwatch modulesTimer) {
        List<Module> modules;
        block3: {
            modules = context.getNormalModules();
            Boolean configureFromGuice = (Boolean)context.option(GuiceyOptions.AnalyzeGuiceModules);
            if (modules.size() > 1 && configureFromGuice.booleanValue()) {
                GuiceBootstrapModule bootstrap = (GuiceBootstrapModule)modules.remove(modules.size() - 1);
                try {
                    Stopwatch gtime = context.stat().timer(Stat.BindingsResolutionTime);
                    ArrayList<Element> elements = new ArrayList<Element>(Elements.getElements((Stage)((Stage)context.option(GuiceyOptions.InjectorStage)), modules));
                    gtime.stop();
                    modulesTimer.stop();
                    ModulesSupport.analyzeAndFilterBindings(context, modules, elements);
                    modulesTimer.start();
                    modules = Arrays.asList(Elements.getModule(elements), bootstrap);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to analyze guice bindings - skipping this step. Note that configuration from bindings may be switched off with " + GuiceyOptions.class.getSimpleName() + "." + GuiceyOptions.AnalyzeGuiceModules.name() + " option.", (Throwable)ex);
                    modules.add((Module)bootstrap);
                    if (modulesTimer.isRunning()) break block3;
                    modulesTimer.start();
                }
            }
        }
        return modules;
    }

    private static void analyzeAndFilterBindings(ConfigurationContext context, List<Module> analyzedModules, List<Element> elements) {
        Stopwatch itimer = context.stat().timer(Stat.InstallersTime);
        Stopwatch timer = context.stat().timer(Stat.ExtensionsRecognitionTime);
        context.stat().count(Stat.BindingsCount, elements.size());
        List<String> disabledModules = ModulesSupport.prepareDisabledModules(context);
        HashSet<String> actuallyDisabledModules = new HashSet<String>();
        ArrayList<Binding> removedBindings = new ArrayList<Binding>();
        Iterator<Element> it = elements.iterator();
        ArrayList extensions = new ArrayList();
        while (it.hasNext()) {
            Element element = it.next();
            if (ModulesSupport.isInDisabledModule(element, disabledModules, actuallyDisabledModules)) {
                it.remove();
                context.stat().count(Stat.RemovedBindingsCount, 1);
                continue;
            }
            if (!(element instanceof Binding) || !ModulesSupport.checkBindingRemoveRequired(context, (Binding)element, extensions)) continue;
            it.remove();
            removedBindings.add((Binding)element);
        }
        if (!actuallyDisabledModules.isEmpty()) {
            LOGGER.debug("Removed inner guice modules: {}", actuallyDisabledModules);
        }
        context.stat().count(Stat.RemovedInnerModules, actuallyDisabledModules.size());
        context.stat().count(Stat.RemovedBindingsCount, removedBindings.size());
        context.lifecycle().modulesAnalyzed(analyzedModules, extensions, ModulesSupport.toModuleClasses(actuallyDisabledModules), removedBindings);
        timer.stop();
        itimer.stop();
    }

    private static boolean checkBindingRemoveRequired(ConfigurationContext context, Binding binding, List<Class<?>> extensions) {
        Key key = binding.getKey();
        if (key.getAnnotation() == null && key.getTypeLiteral().getType() instanceof Class) {
            context.stat().count(Stat.AnalyzedBindingsCount, 1);
            Class type = key.getTypeLiteral().getRawType();
            if (ExtensionsSupport.registerExtensionBinding(context, type, binding, BindingUtils.getTopDeclarationModule((Element)binding))) {
                LOGGER.debug("Extension detected from guice binding: {}", (Object)type.getSimpleName());
                extensions.add(type);
                return !context.isExtensionEnabled(type);
            }
        }
        return false;
    }

    private static List<String> prepareDisabledModules(ConfigurationContext context) {
        ArrayList<String> res = new ArrayList<String>();
        for (Class<Object> cls : context.getDisabledModuleTypes()) {
            res.add(cls.getName());
        }
        return res;
    }

    private static boolean isInDisabledModule(Element element, List<String> disabled, Set<String> actuallyDisabled) {
        if (!disabled.isEmpty()) {
            List<String> modules = BindingUtils.getModules(element);
            for (int i = modules.size() - 1; i >= 0; --i) {
                String mod = modules.get(i);
                if (!disabled.contains(mod)) continue;
                actuallyDisabled.add(mod);
                return true;
            }
        }
        return false;
    }

    private static List<Class<? extends Module>> toModuleClasses(Set<String> modules) {
        if (modules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Class<? extends Module>> res = new ArrayList<Class<? extends Module>>();
        for (String mod : modules) {
            res.add(BindingUtils.getModuleClass(mod));
        }
        return res;
    }
}

