/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.util;

import com.google.inject.Binding;
import com.google.inject.Module;
import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public final class BindingUtils {
    public static final String JIT_MODULE = "JIT";

    private BindingUtils() {
    }

    public static List<String> getModules(Element element) {
        List modules;
        if (element.getSource() instanceof ElementSource) {
            ElementSource source = (ElementSource)element.getSource();
            if (source.getOriginalElementSource() != null) {
                source = source.getOriginalElementSource();
            }
            modules = source.getModuleClassNames();
        } else {
            modules = Collections.singletonList(JIT_MODULE);
        }
        return modules;
    }

    public static Class<? extends Module> getModuleClass(String name) {
        Class res;
        if (!name.equals(JIT_MODULE)) {
            try {
                res = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to resolve module class", e);
            }
        } else {
            res = Module.class;
        }
        return res;
    }

    public static Class<? extends Module> getTopDeclarationModule(Element element) {
        List<String> modulesStack = BindingUtils.getModules(element);
        return BindingUtils.getModuleClass(modulesStack.get(modulesStack.size() - 1));
    }

    public static String getDeclarationSource(Binding binding) {
        String res = "UNKNOWN";
        Object source = binding.getSource();
        if (source instanceof ElementSource) {
            ElementSource src = (ElementSource)source;
            StackTraceElement traceElement = null;
            if (src.getDeclaringSource() instanceof StackTraceElement) {
                traceElement = (StackTraceElement)src.getDeclaringSource();
            } else if (src.getDeclaringSource() instanceof Method) {
                traceElement = (StackTraceElement)StackTraceElements.forMember((Member)((Method)src.getDeclaringSource()));
            }
            if (traceElement != null) {
                res = traceElement.toString();
            }
        } else if (source instanceof Class) {
            res = ((Class)source).getName();
        }
        return res;
    }
}

