/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.jersey;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import io.dropwizard.Application;
import io.dropwizard.setup.Environment;
import java.util.EnumSet;
import javax.inject.Provider;
import org.glassfish.jersey.internal.inject.InjectionManager;
import ru.vyarus.dropwizard.guice.GuiceyOptions;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorProvider;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.installer.InstallersOptions;
import ru.vyarus.dropwizard.guice.module.jersey.GuiceFeature;
import ru.vyarus.dropwizard.guice.module.jersey.GuiceWebModule;
import ru.vyarus.dropwizard.guice.module.jersey.hk2.GuiceBindingsModule;

public class Jersey2Module
extends AbstractModule {
    private final Application application;
    private final Environment environment;
    private final ConfigurationContext context;

    public Jersey2Module(Application application, Environment environment, ConfigurationContext context) {
        this.application = application;
        this.environment = environment;
        this.context = context;
    }

    protected void configure() {
        this.checkHkFirstMode();
        EnumSet types = (EnumSet)this.context.option(GuiceyOptions.GuiceFilterRegistration);
        boolean guiceServletSupport = !types.isEmpty();
        InjectorProvider provider = new InjectorProvider(this.application);
        this.install((Module)new GuiceBindingsModule(provider, guiceServletSupport));
        GuiceFeature component = new GuiceFeature(provider, this.context.stat(), this.context.lifecycle(), (Boolean)this.context.option(GuiceyOptions.UseHkBridge));
        this.bind(InjectionManager.class).toProvider((Provider)component);
        this.environment.jersey().register((Object)component);
        if (guiceServletSupport) {
            this.install((Module)new GuiceWebModule(this.environment, types));
        }
    }

    private void checkHkFirstMode() {
        boolean guiceyFirstMode = (Boolean)this.context.option(InstallersOptions.JerseyExtensionsManagedByGuice);
        if (!guiceyFirstMode) {
            Preconditions.checkState((boolean)((Boolean)this.context.option(GuiceyOptions.UseHkBridge)), (Object)"HK2 management for jersey extensions is enabled by default (InstallersOptions.JerseyExtensionsManagedByGuice), but HK2-guice bridge is not enabled. Use GuiceyOptions.UseHkBridge option to enable bridge (extra dependency is required)");
        }
    }
}

