/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.lifecycle.event;

import com.google.inject.Injector;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import ru.vyarus.dropwizard.guice.debug.report.diagnostic.DiagnosticConfig;
import ru.vyarus.dropwizard.guice.debug.report.diagnostic.DiagnosticRenderer;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceAopConfig;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceAopMapRenderer;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceBindingsRenderer;
import ru.vyarus.dropwizard.guice.debug.report.guice.GuiceConfig;
import ru.vyarus.dropwizard.guice.debug.report.option.OptionsConfig;
import ru.vyarus.dropwizard.guice.debug.report.option.OptionsRenderer;
import ru.vyarus.dropwizard.guice.debug.report.stat.StatsRenderer;
import ru.vyarus.dropwizard.guice.debug.report.tree.ContextTreeConfig;
import ru.vyarus.dropwizard.guice.debug.report.tree.ContextTreeRenderer;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycle;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.RunPhaseEvent;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public abstract class InjectorPhaseEvent
extends RunPhaseEvent {
    private final Injector injector;
    private final ReportRenderer reportRenderer = new ReportRenderer();

    public InjectorPhaseEvent(GuiceyLifecycle type, Options options, Bootstrap bootstrap, Configuration configuration, ConfigurationTree configurationTree, Environment environment, Injector injector) {
        super(type, options, bootstrap, configuration, configurationTree, environment);
        this.injector = injector;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public GuiceyConfigurationInfo getConfigurationInfo() {
        return (GuiceyConfigurationInfo)this.getInjector().getInstance(GuiceyConfigurationInfo.class);
    }

    public ReportRenderer getReportRenderer() {
        return this.reportRenderer;
    }

    public class ReportRenderer {
        public String renderConfigurationSummary(DiagnosticConfig config) {
            return new DiagnosticRenderer(InjectorPhaseEvent.this.getConfigurationInfo()).renderReport(config);
        }

        public String renderConfigurationTree(ContextTreeConfig config) {
            return new ContextTreeRenderer(InjectorPhaseEvent.this.getConfigurationInfo()).renderReport(config);
        }

        public String renderOptions(OptionsConfig config) {
            return new OptionsRenderer(InjectorPhaseEvent.this.getConfigurationInfo()).renderReport(config);
        }

        public String renderStats(boolean hideTiny) {
            return new StatsRenderer(InjectorPhaseEvent.this.getConfigurationInfo()).renderReport(hideTiny);
        }

        public String renderGuiceBindings(GuiceConfig config) {
            return new GuiceBindingsRenderer(InjectorPhaseEvent.this.getInjector()).renderReport(config);
        }

        public String renderGuiceAop(GuiceAopConfig config) {
            return new GuiceAopMapRenderer(InjectorPhaseEvent.this.getInjector()).renderReport(config);
        }
    }
}

