/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.lifecycle.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.cli.Command;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycle;
import ru.vyarus.dropwizard.guice.module.lifecycle.GuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.GuiceyLifecycleEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BundlesFromLookupResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BundlesInitializedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BundlesResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ClasspathExtensionsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.CommandsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ConfigurationHooksProcessedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.DropwizardBundlesInitializedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.InitializedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.InstallersResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ManualExtensionsValidatedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.ApplicationStartedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.JerseyConfigurationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.JerseyExtensionsInstalledByEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.JerseyExtensionsInstalledEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ApplicationRunEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BeforeRunEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BundlesStartedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsInstalledByEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsInstalledEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.InjectorCreationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ModulesAnalyzedEvent;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public final class LifecycleSupport {
    private final Logger logger = LoggerFactory.getLogger(LifecycleSupport.class);
    private final Options options;
    private Bootstrap bootstrap;
    private Configuration configuration;
    private ConfigurationTree configurationTree;
    private Environment environment;
    private Injector injector;
    private InjectionManager injectionManager;
    private GuiceyLifecycle currentStage;
    private final Set<GuiceyLifecycleListener> listeners = new LinkedHashSet<GuiceyLifecycleListener>();

    public LifecycleSupport(Options options) {
        this.options = options;
    }

    public void register(GuiceyLifecycleListener ... listeners) {
        Arrays.asList(listeners).forEach(l -> {
            if (!this.listeners.add((GuiceyLifecycleListener)l)) {
                this.logger.info("IGNORE duplicate lifecycle listener registration: {}", (Object)l.getClass().getName());
            }
            if (l instanceof GuiceyConfigurationHook) {
                Preconditions.checkState((boolean)this.isBefore(GuiceyLifecycle.ConfigurationHooksProcessed), (String)"Can't register listener as hook because hooks were already processed (current stage is %s).", (Object)((Object)this.currentStage));
                ((GuiceyConfigurationHook)((Object)l)).register();
            }
        });
    }

    public void configurationHooksProcessed(Set<GuiceyConfigurationHook> hooks) {
        if (hooks != null && !hooks.isEmpty()) {
            this.broadcast(new ConfigurationHooksProcessedEvent(this.options, hooks));
        }
    }

    public void initializationStarted(Bootstrap bootstrap, List<ConfiguredBundle> bundles, List<ConfiguredBundle> disabled, List<ConfiguredBundle> ignored) {
        this.bootstrap = bootstrap;
        if (!bundles.isEmpty()) {
            this.broadcast(new DropwizardBundlesInitializedEvent(this.options, bootstrap, bundles, disabled, ignored));
        }
    }

    public void bundlesFromLookupResolved(List<GuiceyBundle> bundles) {
        if (!bundles.isEmpty()) {
            this.broadcast(new BundlesFromLookupResolvedEvent(this.options, this.bootstrap, bundles));
        }
    }

    public void bundlesResolved(List<GuiceyBundle> bundles, List<GuiceyBundle> disabled, List<GuiceyBundle> ignored) {
        this.broadcast(new BundlesResolvedEvent(this.options, this.bootstrap, bundles, disabled, ignored));
    }

    public void bundlesInitialized(List<GuiceyBundle> bundles, List<GuiceyBundle> disabled, List<GuiceyBundle> ignored) {
        if (!bundles.isEmpty()) {
            this.broadcast(new BundlesInitializedEvent(this.options, this.bootstrap, bundles, disabled, ignored));
        }
    }

    public void commandsResolved(List<Command> installed) {
        if (installed != null && !installed.isEmpty()) {
            this.broadcast(new CommandsResolvedEvent(this.options, this.bootstrap, installed));
        }
    }

    public void installersResolved(List<FeatureInstaller> installers, List<Class<? extends FeatureInstaller>> disabled) {
        this.broadcast(new InstallersResolvedEvent(this.options, this.bootstrap, installers, disabled));
    }

    public void manualExtensionsValidated(List<Class<?>> extensions, List<Class<?>> validated) {
        if (!extensions.isEmpty()) {
            this.broadcast(new ManualExtensionsValidatedEvent(this.options, this.bootstrap, extensions, validated));
        }
    }

    public void classpathExtensionsResolved(List<Class<?>> extensions) {
        if (!extensions.isEmpty()) {
            this.broadcast(new ClasspathExtensionsResolvedEvent(this.options, this.bootstrap, extensions));
        }
    }

    public void initialized() {
        this.broadcast(new InitializedEvent(this.options, this.bootstrap));
    }

    public void runPhase(Configuration configuration, ConfigurationTree configurationTree, Environment environment) {
        this.broadcast(new BeforeRunEvent(this.options, this.bootstrap, configuration, configurationTree, environment));
        this.configuration = configuration;
        this.configurationTree = configurationTree;
        this.environment = environment;
        environment.lifecycle().addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleStarted(LifeCycle event) {
                LifecycleSupport.this.applicationStarted();
            }
        });
    }

    public void bundlesStarted(List<GuiceyBundle> bundles) {
        if (!bundles.isEmpty()) {
            this.broadcast(new BundlesStartedEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, bundles));
        }
    }

    public void modulesAnalyzed(List<Module> modules, List<Class<?>> extensions, List<Class<? extends Module>> transitiveModulesRemoved, List<Binding> bindingsRemoved) {
        this.broadcast(new ModulesAnalyzedEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, modules, extensions, transitiveModulesRemoved, bindingsRemoved));
    }

    public void extensionsResolved(List<Class<?>> extensions, List<Class<?>> disabled) {
        this.broadcast(new ExtensionsResolvedEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, extensions, disabled));
    }

    public void injectorCreation(List<Module> modules, List<Module> overriding, List<Module> disabled, List<Module> ignored) {
        this.broadcast(new InjectorCreationEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, modules, overriding, disabled, ignored));
    }

    public void injectorPhase(Injector injector) {
        this.injector = injector;
    }

    public void extensionsInstalled(Class<? extends FeatureInstaller> installer, List<Class<?>> installed) {
        if (installed != null && !installed.isEmpty()) {
            this.broadcast(new ExtensionsInstalledByEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, installer, installed));
        }
    }

    public void extensionsInstalled(List<Class<?>> extensions) {
        if (!extensions.isEmpty()) {
            this.broadcast(new ExtensionsInstalledEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, extensions));
        }
    }

    public void applicationRun() {
        this.broadcast(new ApplicationRunEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector));
    }

    public void jerseyConfiguration(InjectionManager injectionManager) {
        this.broadcast(new JerseyConfigurationEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, injectionManager));
        this.injectionManager = injectionManager;
    }

    public void jerseyExtensionsInstalled(Class<? extends FeatureInstaller> installer, List<Class<?>> installed) {
        if (installed != null && !installed.isEmpty()) {
            this.broadcast(new JerseyExtensionsInstalledByEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, this.injectionManager, installer, installed));
        }
    }

    public void jerseyExtensionsInstalled(List<Class<?>> extensions) {
        if (!extensions.isEmpty()) {
            this.broadcast(new JerseyExtensionsInstalledEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, this.injectionManager, extensions));
        }
    }

    public GuiceyLifecycle getStage() {
        return this.currentStage;
    }

    public boolean isBefore(GuiceyLifecycle lifecycle) {
        return this.getStage() == null || this.getStage().ordinal() < lifecycle.ordinal();
    }

    private void broadcast(GuiceyLifecycleEvent event) {
        this.listeners.forEach(l -> l.onEvent(event));
        this.currentStage = event.getType();
    }

    private void applicationStarted() {
        this.broadcast(new ApplicationStartedEvent(this.options, this.bootstrap, this.configuration, this.configurationTree, this.environment, this.injector, this.injectionManager));
    }
}

