/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.support;

import com.google.inject.AbstractModule;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.List;
import ru.vyarus.dropwizard.guice.module.context.option.Options;
import ru.vyarus.dropwizard.guice.module.support.BootstrapAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationAwareModule;
import ru.vyarus.dropwizard.guice.module.support.ConfigurationTreeAwareModule;
import ru.vyarus.dropwizard.guice.module.support.EnvironmentAwareModule;
import ru.vyarus.dropwizard.guice.module.support.OptionsAwareModule;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public abstract class DropwizardAwareModule<C extends Configuration>
extends AbstractModule
implements EnvironmentAwareModule,
BootstrapAwareModule<C>,
ConfigurationAwareModule<C>,
ConfigurationTreeAwareModule,
OptionsAwareModule {
    private C configuration;
    private Bootstrap<C> bootstrap;
    private Environment environment;
    private Options options;
    private ConfigurationTree configurationTree;

    @Override
    public void setConfiguration(C configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setBootstrap(Bootstrap<C> bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public void setConfigurationTree(ConfigurationTree configurationTree) {
        this.configurationTree = configurationTree;
    }

    protected Bootstrap<C> bootstrap() {
        return this.bootstrap;
    }

    protected C configuration() {
        return this.configuration;
    }

    public <T> T configuration(String yamlPath) {
        return this.configurationTree().valueByPath(yamlPath);
    }

    public <T, K extends T> K configuration(Class<T> type) {
        return this.configurationTree().valueByUniqueDeclaredType(type);
    }

    public <T> List<? extends T> configurations(Class<T> type) {
        return this.configurationTree().valuesByType(type);
    }

    protected ConfigurationTree configurationTree() {
        return this.configurationTree;
    }

    protected Environment environment() {
        return this.environment;
    }

    protected String appPackage() {
        return this.bootstrap().getApplication().getClass().getPackage().getName();
    }

    protected Options options() {
        return this.options;
    }
}

