/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.internal;

import com.google.common.base.Stopwatch;
import com.google.inject.Injector;
import io.dropwizard.Application;
import io.dropwizard.cli.Command;
import io.dropwizard.cli.EnvironmentCommand;
import io.dropwizard.setup.Bootstrap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClassVisitor;
import ru.vyarus.dropwizard.guice.module.installer.scanner.ClasspathScanner;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.InstanceUtils;

public final class CommandSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandSupport.class);

    private CommandSupport() {
    }

    public static List<Command> registerCommands(Bootstrap bootstrap, ClasspathScanner scanner, ConfigurationContext context) {
        Stopwatch timer = context.stat().timer(Stat.CommandTime);
        CommandClassVisitor visitor = new CommandClassVisitor(bootstrap);
        scanner.scan(visitor);
        context.registerCommands(visitor.getCommands());
        timer.stop();
        return visitor.getCommandList();
    }

    public static void initCommands(List<Command> commands, Injector injector) {
        if (commands != null) {
            for (Command cmd : commands) {
                if (!(cmd instanceof EnvironmentCommand)) continue;
                injector.injectMembers((Object)cmd);
            }
        }
    }

    private static class CommandClassVisitor
    implements ClassVisitor {
        private final Bootstrap bootstrap;
        private final Set<Class<Command>> commands = new TreeSet<Class>(Comparator.comparing(Class::getName));
        private final List<Command> commandList = new ArrayList<Command>();

        CommandClassVisitor(Bootstrap bootstrap) {
            this.bootstrap = bootstrap;
        }

        @Override
        public void visit(Class<?> type) {
            if (FeatureUtils.is(type, Command.class)) {
                try {
                    Command cmd = EnvironmentCommand.class.isAssignableFrom(type) ? (Command)InstanceUtils.create(type, Application.class, (Object)this.bootstrap.getApplication()) : (Command)InstanceUtils.create(type);
                    this.commands.add(type);
                    this.commandList.add(cmd);
                    this.bootstrap.addCommand(cmd);
                    LOGGER.debug("Command registered: {}", (Object)type.getSimpleName());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to instantiate command: " + type.getSimpleName(), e);
                }
            }
        }

        public List<Class<Command>> getCommands() {
            return this.commands.isEmpty() ? Collections.emptyList() : new ArrayList<Class<Command>>(this.commands);
        }

        public List<Command> getCommandList() {
            return this.commandList;
        }
    }
}

