/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test;

import com.google.common.base.Preconditions;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.DropwizardTestSupport;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClient;
import ru.vyarus.dropwizard.guice.module.installer.util.PathUtils;
import ru.vyarus.dropwizard.guice.test.client.DefaultTestClientFactory;
import ru.vyarus.dropwizard.guice.test.client.TestClientFactory;

public class ClientSupport
implements AutoCloseable {
    private static final String HTTP_LOCALHOST = "http://localhost:";
    private final DropwizardTestSupport<?> support;
    private final TestClientFactory factory;
    private JerseyClient client;

    public ClientSupport(DropwizardTestSupport<?> support) {
        this(support, null);
    }

    public ClientSupport(DropwizardTestSupport<?> support, @Nullable TestClientFactory factory) {
        this.support = support;
        this.factory = factory == null ? new DefaultTestClientFactory() : factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JerseyClient getClient() {
        ClientSupport clientSupport = this;
        synchronized (clientSupport) {
            if (this.client == null) {
                this.client = this.factory.create(this.support);
            }
            return this.client;
        }
    }

    public int getPort() {
        return this.support.getLocalPort();
    }

    public int getAdminPort() {
        return this.support.getAdminPort();
    }

    public String basePathRoot() {
        return PathUtils.trailingSlash(PathUtils.path(HTTP_LOCALHOST + this.getPort()));
    }

    public String basePathMain() {
        String contextMapping = this.support.getEnvironment().getApplicationContext().getContextPath();
        return PathUtils.trailingSlash(PathUtils.path(this.basePathRoot(), contextMapping));
    }

    public String basePathAdmin() {
        String contextMapping = this.support.getEnvironment().getAdminContext().getContextPath();
        return PathUtils.trailingSlash(PathUtils.path(HTTP_LOCALHOST + this.getAdminPort(), contextMapping));
    }

    public String basePathRest() {
        Environment env = this.support.getEnvironment();
        String contextPath = env.getJerseyServletContainer().getServletConfig().getServletContext().getContextPath();
        String restMapping = PathUtils.trailingSlash(PathUtils.trimStars(env.jersey().getUrlPattern()));
        return PathUtils.trailingSlash(PathUtils.path(this.basePathRoot(), contextPath, restMapping));
    }

    public WebTarget target(String ... paths) {
        Preconditions.checkState((paths.length != 0 ? 1 : 0) != 0, (Object)"Target required (e.g. http://localhost:8080/)");
        return this.getClient().target(PathUtils.path(paths));
    }

    public WebTarget targetMain(String ... paths) {
        return this.target(this.merge(this.basePathMain(), paths));
    }

    public WebTarget targetAdmin(String ... paths) {
        return this.target(this.merge(this.basePathAdmin(), paths));
    }

    public WebTarget targetRest(String ... paths) {
        return this.target(this.merge(this.basePathRest(), paths));
    }

    public <T> T get(String rootPath, @Nullable Class<T> result) {
        if (result != null) {
            return (T)this.target(this.basePathRoot(), rootPath).request().get(result);
        }
        this.checkVoidResponse(() -> this.target(this.basePathRoot(), rootPath).request().get());
        return null;
    }

    public <T> T post(String rootPath, @Nullable Object body, @Nullable Class<T> result) {
        if (result != null) {
            return (T)this.target(this.basePathRoot(), rootPath).request().post(Entity.json((Object)body), result);
        }
        this.checkVoidResponse(() -> this.target(this.basePathRoot(), rootPath).request().post(Entity.json((Object)body)));
        return null;
    }

    public <T> T put(String rootPath, Object body, @Nullable Class<T> result) {
        if (result != null) {
            return (T)this.target(this.basePathRoot(), rootPath).request().put(Entity.json((Object)body), result);
        }
        this.checkVoidResponse(() -> this.target(this.basePathRoot(), rootPath).request().put(Entity.json((Object)body)));
        return null;
    }

    public <T> T delete(String rootPath, @Nullable Class<T> result) {
        if (result != null) {
            return (T)this.target(this.basePathRoot(), rootPath).request().delete(result);
        }
        this.checkVoidResponse(() -> this.target(this.basePathRoot(), rootPath).request().delete());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        ClientSupport clientSupport = this;
        synchronized (clientSupport) {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
    }

    public void checkVoidResponse(Supplier<Response> call) {
        try (Response res = call.get();){
            if (!Arrays.asList(200, 204).contains(res.getStatus())) {
                throw new IllegalStateException("Invalid response: " + res.getStatus() + "\n" + (String)res.readEntity(String.class));
            }
        }
    }

    private String[] merge(String base, String ... addition) {
        String[] res;
        if (addition.length == 0) {
            res = new String[]{base};
        } else {
            res = new String[addition.length + 1];
            res[0] = base;
            System.arraycopy(addition, 0, res, 1, addition.length);
        }
        return res;
    }
}

