/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.yaml;

import com.google.common.collect.LinkedHashMultimap;
import com.google.inject.Key;
import io.dropwizard.Configuration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.report.yaml.BindingsConfig;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.debug.util.TreeNode;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigPath;
import ru.vyarus.dropwizard.guice.module.yaml.ConfigurationTree;

public class ConfigBindingsRenderer
implements ReportRenderer<BindingsConfig> {
    private static final String EQUAL = " = ";
    private static final String CONFIG = "@Config";
    private static final String SPACE = " ";
    private final ConfigurationTree tree;

    public ConfigBindingsRenderer(ConfigurationTree tree) {
        this.tree = tree;
    }

    @Override
    public String renderReport(BindingsConfig config) {
        StringBuilder res = new StringBuilder();
        if (config.isShowConfigurationTree()) {
            this.renderConfigurationTree(config, res);
        }
        if (config.isShowBindings()) {
            this.renderRootTypes(config, res);
            this.renderUniqueSubConfigs(config, res);
            this.renderQualified(res);
            this.renderPaths(config, res);
        }
        return res.toString();
    }

    private void renderConfigurationTree(BindingsConfig config, StringBuilder res) {
        TreeNode node = new TreeNode(this.tree.getRootTypes().get(0).getSimpleName() + " (visible paths)", new Object[0]);
        this.tree.findAllRootPaths().forEach(it -> this.renderSubtree(node, (ConfigPath)it, config));
        if (node.hasChildren()) {
            res.append(Reporter.NEWLINE).append(Reporter.NEWLINE);
            node.render(res);
        }
    }

    private void renderSubtree(TreeNode root, ConfigPath path, BindingsConfig config) {
        if (this.isHidden(path, config)) {
            return;
        }
        StringBuilder name = new StringBuilder().append(path.getLastPathLevel()).append(": ").append(path.toStringType());
        if (!path.isCustomType()) {
            name.append(EQUAL).append(path.toStringValue());
        }
        TreeNode node = root.child(name.toString(), new Object[0]);
        path.getChildren().forEach(it -> this.renderSubtree(node, (ConfigPath)it, config));
    }

    private void renderRootTypes(BindingsConfig config, StringBuilder res) {
        if (this.tree.getRootTypes().size() == 1 && config.isShowCustomConfigOnly()) {
            return;
        }
        res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("Configuration object bindings:").append(Reporter.NEWLINE);
        for (Class type : this.tree.getRootTypes()) {
            if (config.isShowCustomConfigOnly() && type.equals(Configuration.class)) continue;
            res.append("    ").append("    ").append(CONFIG).append(SPACE).append(type.getSimpleName()).append(Reporter.NEWLINE);
        }
    }

    private void renderUniqueSubConfigs(BindingsConfig config, StringBuilder res) {
        boolean header = false;
        for (ConfigPath item : this.tree.getUniqueTypePaths()) {
            if (this.isHidden(item, config)) continue;
            if (!header) {
                res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("Unique sub configuration objects bindings:").append(Reporter.NEWLINE);
                header = true;
            }
            res.append(Reporter.NEWLINE).append("    ").append("    ").append(item.getRootDeclarationClass().getSimpleName()).append('.').append(item.getPath()).append(Reporter.NEWLINE).append("    ").append("    ").append("    ").append(CONFIG).append(SPACE);
            this.renderPath(item, res);
            res.append(Reporter.NEWLINE);
        }
    }

    private void renderQualified(StringBuilder res) {
        LinkedHashMultimap bindings = LinkedHashMultimap.create();
        for (ConfigPath item : this.tree.getPaths()) {
            if (item.getQualifier() == null) continue;
            Key key = Key.get((Type)item.getDeclaredTypeWithGenerics(), (Annotation)item.getQualifier());
            bindings.put((Object)key, (Object)item);
        }
        boolean header = false;
        for (Key key : bindings.keySet()) {
            Collection values = bindings.get((Object)key);
            ConfigPath first = (ConfigPath)values.iterator().next();
            Annotation qualifier = first.getQualifier();
            if (qualifier == null) continue;
            if (!header) {
                res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("Qualified bindings:").append(Reporter.NEWLINE);
                header = true;
            }
            res.append("    ").append("    ").append(RenderUtils.renderAnnotation(qualifier)).append(' ');
            if (values.size() > 1) {
                res.append("Set<").append(first.toStringDeclaredType()).append("> = (aggregated values)\n");
                for (ConfigPath path : values) {
                    res.append("    ").append("    ").append("    ");
                    this.renderPath(path, res);
                    res.append(" (").append(path.getPath()).append(')').append(Reporter.NEWLINE);
                }
                continue;
            }
            this.renderPath(first, res);
            res.append(" (").append(first.getPath()).append(')').append(Reporter.NEWLINE);
        }
    }

    private void renderPaths(BindingsConfig config, StringBuilder res) {
        boolean header = false;
        Class rootConfig = null;
        for (ConfigPath item : this.tree.getPaths()) {
            if (this.isHidden(item, config)) continue;
            if (!header) {
                res.append(Reporter.NEWLINE).append(Reporter.NEWLINE).append("    ").append("Configuration paths bindings:").append(Reporter.NEWLINE);
                header = true;
            }
            if (rootConfig != item.getRootDeclarationClass()) {
                rootConfig = item.getRootDeclarationClass();
                res.append(Reporter.NEWLINE).append("    ").append("    ").append(rootConfig.getSimpleName()).append(':').append(Reporter.NEWLINE);
            }
            res.append("    ").append("    ").append("    ").append(CONFIG).append("(\"").append(item.getPath()).append("\") ");
            this.renderPath(item, res);
            res.append(Reporter.NEWLINE);
        }
    }

    private void renderPath(ConfigPath path, StringBuilder res) {
        res.append(path.toStringDeclaredType()).append(path.isObjectDeclaration() ? Character.valueOf('*') : "");
        if (path.getDeclaredType() != path.getValueType()) {
            res.append(" (with actual type ").append(path.toStringType()).append(')');
        }
        res.append(EQUAL).append(path.toStringValue());
    }

    private boolean isHidden(ConfigPath path, BindingsConfig config) {
        return !config.isShowNullValues() && path.getValue() == null || config.isShowCustomConfigOnly() && path.getRootDeclarationClass().equals(Configuration.class);
    }
}

