/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import com.google.inject.Module;
import io.dropwizard.ConfiguredBundle;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.impl.CommandItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.DropwizardBundleItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ExtensionItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.GuiceyBundleItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.InstallerItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ModuleItemInfoImpl;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBundle;

public enum ConfigItem {
    Installer(false),
    Extension(false),
    DropwizardBundle(true),
    Bundle(true),
    Module(true),
    Command(false);

    private boolean instanceConfig;

    private ConfigItem(boolean instanceConfig) {
        this.instanceConfig = instanceConfig;
    }

    public boolean isInstanceConfig() {
        return this.instanceConfig;
    }

    public <T extends ItemInfoImpl> T newContainer(Object item) {
        ItemInfoImpl res;
        switch (this) {
            case Installer: {
                res = new InstallerItemInfoImpl((Class)item);
                break;
            }
            case Extension: {
                res = new ExtensionItemInfoImpl((Class)item);
                break;
            }
            case DropwizardBundle: {
                res = item instanceof Class ? new DropwizardBundleItemInfoImpl((Class)item) : new DropwizardBundleItemInfoImpl((ConfiguredBundle)item);
                break;
            }
            case Bundle: {
                res = item instanceof Class ? new GuiceyBundleItemInfoImpl((Class)item) : new GuiceyBundleItemInfoImpl((GuiceyBundle)item);
                break;
            }
            case Command: {
                res = new CommandItemInfoImpl((Class)item);
                break;
            }
            case Module: {
                res = item instanceof Class ? new ModuleItemInfoImpl((Class)item) : new ModuleItemInfoImpl((Module)item);
                break;
            }
            default: {
                res = new ItemInfoImpl(this, ItemId.from(item));
            }
        }
        return (T)res;
    }
}

