/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.cmd;

import com.google.common.base.MoreObjects;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import java.util.ArrayList;
import java.util.List;
import ru.vyarus.dropwizard.guice.test.builder.BaseBuilder;
import ru.vyarus.dropwizard.guice.test.cmd.CommandResult;
import ru.vyarus.dropwizard.guice.test.cmd.CommandTestSupport;

public class CommandRunBuilder<C extends Configuration>
extends BaseBuilder<C, CommandRunBuilder<C>> {
    private String[] inputs;
    private final List<CommandListener<C>> listeners = new ArrayList<CommandListener<C>>();

    public CommandRunBuilder(Class<? extends Application<C>> app) {
        super(app);
    }

    public CommandRunBuilder<C> consoleInputs(String ... inputs) {
        this.inputs = inputs;
        return this;
    }

    public CommandRunBuilder<C> listen(CommandListener<C> listener) {
        this.listeners.add(listener);
        return this;
    }

    public CommandResult<C> runApp() {
        return this.run("server");
    }

    public CommandResult<C> run(String ... args) {
        for (CommandListener<C> listener : this.listeners) {
            listener.setup(args);
        }
        CommandResult<C> result = this.inputs == null ? this.build().run(args) : this.build().run(this.inputs, args);
        for (CommandListener<C> listener : this.listeners) {
            listener.cleanup(result);
        }
        return result;
    }

    private CommandTestSupport<C> build() {
        CommandTestSupport<Object> support;
        if (this.configObject != null) {
            if (this.configPath != null || !this.configOverrides.isEmpty() || this.configSourceProvider != null) {
                throw new IllegalStateException("Configuration object can't be used together with yaml configuration");
            }
            support = new CommandTestSupport<Configuration>(this.app, this.configObject);
        } else {
            String prefix = (String)MoreObjects.firstNonNull((Object)this.propertyPrefix, (Object)"dw.");
            support = new CommandTestSupport(this.app, this.configPath, this.configSourceProvider, prefix, this.prepareOverrides(prefix));
        }
        return support;
    }

    public static interface CommandListener<C extends Configuration> {
        default public void setup(String ... args) {
        }

        default public void cleanup(CommandResult<C> result) {
        }
    }
}

