/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.junit.platform.commons.util.ReflectionUtils;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;

public final class RegistrationTrackUtils {
    private RegistrationTrackUtils() {
    }

    public static void fromClass(List<String> info, String prefix, Class<?>[] classes) {
        RegistrationTrackUtils.track(info, Arrays.asList(classes), it -> it, it -> prefix);
    }

    public static void fromInstance(List<String> info, String prefix, Object[] instances) {
        RegistrationTrackUtils.track(info, Arrays.asList(instances), Object::getClass, obj -> prefix);
    }

    public static void fromField(List<String> info, String prefix, List<Field> fields, Object instance) {
        RegistrationTrackUtils.track(info, fields, field -> ReflectionUtils.tryToReadFieldValue((Field)field, (Object)instance).orElseTry(() -> new Exception()).toOptional().map(Object::getClass).get(), field -> prefix + " field " + field.getDeclaringClass().getSimpleName() + "." + field.getName());
    }

    private static <T> void track(List<String> info, List<T> objects, Function<T, Class> converter, Function<T, String> marker) {
        for (T obj : objects) {
            Class cls = converter.apply(obj);
            info.add(String.format("%-80s \t%s", RenderUtils.renderClassLine(cls), marker.apply(obj)));
        }
    }
}

