/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import ru.vyarus.dropwizard.guice.test.jupiter.env.EnableSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestExtension;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.ExtensionConfig;

public final class TestSetupUtils {
    private TestSetupUtils() {
    }

    @SafeVarargs
    public static List<TestEnvironmentSetup> create(Class<? extends TestEnvironmentSetup> ... extensions) {
        ArrayList<TestEnvironmentSetup> res = new ArrayList<TestEnvironmentSetup>();
        for (Class<? extends TestEnvironmentSetup> ext : extensions) {
            try {
                res.add(ext.newInstance());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate test support object: " + ext.getSimpleName(), e);
            }
        }
        return res;
    }

    public static void executeSetup(ExtensionConfig config, ExtensionContext context) {
        if (!config.extensions.isEmpty()) {
            TestExtension builder = new TestExtension(config);
            ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{TestEnvironmentSetup.class}));
            for (TestEnvironmentSetup support : config.extensions) {
                config.tracker.setContextHook(support.getClass());
                Object res = support.setup(builder);
                if (!(res instanceof AutoCloseable) && !(res instanceof ExtensionContext.Store.CloseableResource)) continue;
                store.put(support.getClass(), (Object)ClosableWrapper.create(res));
            }
        }
    }

    public static void validateFields(List<Field> fields, boolean includeInstanceFields) {
        for (Field field : fields) {
            if (!TestEnvironmentSetup.class.isAssignableFrom(field.getType())) {
                throw new IllegalStateException(String.format("Field %s annotated with @%s, but its type is not %s", TestSetupUtils.toString(field), EnableSetup.class.getSimpleName(), TestEnvironmentSetup.class.getSimpleName()));
            }
            if (includeInstanceFields || Modifier.isStatic(field.getModifiers())) continue;
            throw new IllegalStateException(String.format("Field %s annotated with @%s must be static", TestSetupUtils.toString(field), EnableSetup.class.getSimpleName()));
        }
    }

    private static String toString(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }

    public static class ClosableWrapper
    implements ExtensionContext.Store.CloseableResource {
        private final AutoCloseable obj;

        public ClosableWrapper(AutoCloseable obj) {
            this.obj = obj;
        }

        public void close() throws Throwable {
            this.obj.close();
        }

        public static ExtensionContext.Store.CloseableResource create(Object obj) {
            return obj instanceof ExtensionContext.Store.CloseableResource ? (ExtensionContext.Store.CloseableResource)obj : new ClosableWrapper((AutoCloseable)obj);
        }
    }
}

