/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.info;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ItemId<T> {
    private final Class<T> type;
    private final String id;

    private ItemId(Class<?> type, String identity) {
        this.type = (Class)Preconditions.checkNotNull(type);
        this.id = identity;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getIdentity() {
        return this.id;
    }

    public String toString() {
        return this.type.getSimpleName() + (this.id == null ? "" : "@" + this.id);
    }

    public static String identity(Object instance) {
        return Integer.toHexString(System.identityHashCode(instance));
    }

    public static <T> ItemId<T> from(Object instance) {
        return instance instanceof Class ? ItemId.from((Class)instance) : new ItemId<T>(instance.getClass(), ItemId.identity(instance));
    }

    public static <T> ItemId<T> from(Class<?> type) {
        return new ItemId<T>(type, null);
    }

    public static <T> List<Class<T>> typesOnly(Collection<ItemId<T>> items) {
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Class<T>> res = new ArrayList<Class<T>>();
        for (ItemId<T> item : items) {
            if (res.contains(item.getType())) continue;
            res.add(item.getType());
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemId)) {
            return false;
        }
        ItemId key = (ItemId)o;
        if (!this.type.equals(key.type)) {
            return false;
        }
        return Objects.equals(this.id, key.id) || this.id == null || key.getIdentity() == null;
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

