/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.installer.feature.health;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.setup.Environment;
import java.util.Collections;
import java.util.List;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.FeatureInstaller;
import ru.vyarus.dropwizard.guice.module.installer.feature.health.NamedHealthCheck;
import ru.vyarus.dropwizard.guice.module.installer.install.InstanceInstaller;
import ru.vyarus.dropwizard.guice.module.installer.order.Order;
import ru.vyarus.dropwizard.guice.module.installer.util.FeatureUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

@Order(value=60)
public class HealthCheckInstaller
implements FeatureInstaller,
InstanceInstaller<NamedHealthCheck> {
    private final Reporter reporter = new Reporter(HealthCheckInstaller.class, "health checks =");

    @Override
    public boolean matches(Class<?> type) {
        return FeatureUtils.is(type, NamedHealthCheck.class);
    }

    @Override
    public void install(Environment environment, NamedHealthCheck instance) {
        environment.healthChecks().register(instance.getName(), (HealthCheck)instance);
        this.reporter.line("%-20s %s", instance.getName(), RenderUtils.renderClassLine(FeatureUtils.getInstanceClass(instance)));
    }

    @Override
    public void report() {
        this.reporter.report();
    }

    @Override
    public List<String> getRecognizableSigns() {
        return Collections.singletonList("extends " + NamedHealthCheck.class.getSimpleName());
    }
}

