/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.conf;

import io.dropwizard.testing.ConfigOverride;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.ext.conf.TestExtensionsTracker;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;
import ru.vyarus.dropwizard.guice.test.util.TestSetupUtils;

public abstract class ExtensionConfig {
    public String[] configOverrides = new String[0];
    public final List<ConfigOverride> configOverrideObjects = new ArrayList<ConfigOverride>();
    public final List<GuiceyConfigurationHook> hooks = new ArrayList<GuiceyConfigurationHook>();
    public final List<TestEnvironmentSetup> extensions = new ArrayList<TestEnvironmentSetup>();
    public final TestExtensionsTracker tracker;
    public boolean reuseApp;
    public Class<?> reuseDeclarationClass;
    public String reuseSource;

    public ExtensionConfig(TestExtensionsTracker tracker) {
        this.tracker = tracker;
    }

    @SafeVarargs
    public final void extensionsFromAnnotation(Class<? extends Annotation> ann, Class<? extends TestEnvironmentSetup> ... exts) {
        this.extensions.addAll(TestSetupUtils.create(exts));
        this.tracker.extensionsFromAnnotation(ann, exts);
    }

    @SafeVarargs
    public final void hooksFromAnnotation(Class<? extends Annotation> ann, Class<? extends GuiceyConfigurationHook> ... exts) {
        this.hooks.addAll(HooksUtil.create(exts));
        this.tracker.hooksFromAnnotation(ann, exts);
    }

    public final void hookInstances(GuiceyConfigurationHook ... exts) {
        Collections.addAll(this.hooks, exts);
        this.tracker.hookInstances(exts);
    }

    @SafeVarargs
    public final void hookClasses(Class<? extends GuiceyConfigurationHook> ... exts) {
        this.hooks.addAll(HooksUtil.create(exts));
        this.tracker.hookClasses(exts);
    }
}

