/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.tree;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ru.vyarus.dropwizard.guice.debug.report.ReportRenderer;
import ru.vyarus.dropwizard.guice.debug.report.tree.ContextTreeConfig;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.debug.util.TreeNode;
import ru.vyarus.dropwizard.guice.module.GuiceyConfigurationInfo;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigScope;
import ru.vyarus.dropwizard.guice.module.context.Filters;
import ru.vyarus.dropwizard.guice.module.context.info.BundleItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ExtensionItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.InstanceItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.sign.DisableSupport;
import ru.vyarus.dropwizard.guice.module.installer.util.Reporter;

public class ContextTreeRenderer
implements ReportRenderer<ContextTreeConfig> {
    private static final String DUPLICATE = "DUPLICATE";
    private static final String DISABLED = "DISABLED";
    private final GuiceyConfigurationInfo service;

    public ContextTreeRenderer(GuiceyConfigurationInfo service) {
        this.service = service;
    }

    @Override
    public String renderReport(ContextTreeConfig config) {
        Set<ItemId> scopes = this.service.getActiveScopes(!config.isHideDisables());
        TreeNode root = new TreeNode("APPLICATION", new Object[0]);
        if (!config.getHiddenScopes().contains(ConfigScope.Application.getType())) {
            this.renderScopeContent(config, root, ConfigScope.Application.getKey());
        }
        this.renderSpecialScope(config, scopes, root, "BUNDLES LOOKUP", ConfigScope.BundleLookup);
        this.renderSpecialScope(config, scopes, root, "CLASSPATH SCAN", ConfigScope.ClasspathScan);
        this.renderGuiceBindings(config, scopes, root);
        this.renderSpecialScope(config, scopes, root, "HOOKS", ConfigScope.Hook);
        StringBuilder res = new StringBuilder().append(Reporter.NEWLINE).append(Reporter.NEWLINE);
        root.render(res);
        return res.toString();
    }

    private void renderSpecialScope(ContextTreeConfig config, Set<ItemId> scopes, TreeNode root, String name, ConfigScope scope) {
        if (this.isScopeVisible(config, scopes, scope.getKey())) {
            TreeNode node = new TreeNode(name, new Object[0]);
            this.renderScopeContent(config, node, scope.getKey());
            if (node.hasChildren()) {
                root.child(node);
            }
        }
    }

    private void renderGuiceBindings(ContextTreeConfig config, Set<ItemId> scopes, TreeNode root) {
        if (config.getHiddenScopes().contains(ConfigScope.Module.getType()) || config.getHiddenItems().contains((Object)ConfigItem.Module)) {
            return;
        }
        TreeNode bindings = new TreeNode("GUICE BINDINGS", new Object[0]);
        for (ItemId scope : scopes) {
            if (!ConfigScope.recognize(scope).equals((Object)ConfigScope.Module)) continue;
            TreeNode module = new TreeNode(RenderUtils.renderClassLine(scope.getType()), new Object[0]);
            this.renderScopeItems(config, module, scope);
            if (!module.hasChildren()) continue;
            bindings.child(module);
        }
        if (bindings.hasChildren()) {
            root.child(bindings);
        }
    }

    private void renderScopeContent(ContextTreeConfig config, TreeNode root, ItemId scope) {
        this.renderScopeItems(config, root, scope);
        List<ItemId<Object>> bundles = this.service.getData().getItems(Filters.bundles().and(Filters.registeredBy(scope)));
        for (ItemId<Object> bundle : bundles) {
            this.renderBundle(config, root, scope, bundle);
        }
    }

    private void renderScopeItems(ContextTreeConfig config, TreeNode root, ItemId scope) {
        List<ItemId<Object>> items = this.service.getData().getItems(Filters.bundles().negate().and(Filters.registeredBy(scope)));
        ArrayList markers = Lists.newArrayList();
        for (ItemId<Object> item : items) {
            Object info = this.service.getData().getInfo(item);
            if (!this.isHidden(config, (ItemInfo)info, scope)) {
                this.renderItem(root, scope, (ItemInfo)info, markers, false);
            }
            if (config.isHideDuplicateRegistrations() || !scope.equals(info.getRegistrationScope()) || info.getIgnoresByScope(scope) <= 0) continue;
            this.renderItem(root, scope, (ItemInfo)info, markers, true);
        }
        if (!config.isHideDisables()) {
            List<ItemId<Object>> disabled = this.service.getData().getItems(Filters.disabledBy(scope));
            for (ItemId<Object> item : disabled) {
                this.renderLeaf(root, "-disable", item, 0, null);
            }
        }
    }

    private void renderItem(TreeNode root, ItemId scope, ItemInfo info, List<String> markers, boolean asIgnore) {
        markers.clear();
        this.fillCommonMarkers(info, markers, scope, asIgnore);
        this.renderLeaf(root, info.getItemType().name().toLowerCase(), info.getId(), info.getItemType().isInstanceConfig() ? ((InstanceItemInfo)info).getInstanceCount() : 0, markers);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    private void renderLeaf(TreeNode root, String name, ItemId<?> item, int pos, List<String> markers) {
        boolean ignored = markers != null && markers.stream().anyMatch(it -> it.equals(DISABLED) || it.startsWith(DUPLICATE));
        root.child(String.format("%-10s ", name) + (ignored ? RenderUtils.renderDisabledClassLine(item.getType(), pos, markers) : RenderUtils.renderClassLine(item.getType(), pos, markers)), new Object[0]);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    private void renderBundle(ContextTreeConfig config, TreeNode root, ItemId<?> scope, ItemId<Object> bundle) {
        BundleItemInfo info = (BundleItemInfo)this.service.getData().getInfo(bundle);
        ArrayList markers = Lists.newArrayList();
        if (!this.isHidden(config, info, scope)) {
            this.fillCommonMarkers(info, markers, scope, false);
            boolean duplicate = markers.stream().anyMatch(it -> it.startsWith(DUPLICATE));
            TreeNode node = new TreeNode(duplicate || markers.contains(DISABLED) ? RenderUtils.renderDisabledClassLine(bundle.getType(), info.getInstanceCount(), markers) : RenderUtils.renderClassLine(bundle.getType(), info.getInstanceCount(), markers), new Object[0]);
            if (!this.isDuplicateRegistration(info, scope)) {
                this.renderScopeContent(config, node, bundle);
            }
            if (node.hasChildren() || !config.isHideEmptyBundles() || !config.isHideDisables() && duplicate) {
                root.child(node);
            }
        }
        if (!config.isHideDuplicateRegistrations() && scope.equals(info.getRegistrationScope()) && info.getIgnoresByScope(scope) > 0) {
            markers.clear();
            this.fillCommonMarkers(info, markers, scope, true);
            root.child(RenderUtils.renderDisabledClassLine(bundle.getType(), info.getInstanceCount(), markers), new Object[0]);
        }
    }

    private void fillCommonMarkers(ItemInfo info, List<String> markers, ItemId scope, boolean asIgnore) {
        if (info.getItemType() == ConfigItem.DropwizardBundle) {
            markers.add("DW");
        }
        if (info.getItemType() == ConfigItem.Extension && ((ExtensionItemInfo)info).isOptional()) {
            markers.add("OPTIONAL");
        }
        if (asIgnore || this.isDuplicateRegistration(info, scope)) {
            int cnt = info.getIgnoresByScope(scope);
            markers.add(DUPLICATE + (String)(cnt > 1 ? "(" + cnt + ")" : ""));
        }
        if (this.isDisabled(info)) {
            markers.add(DISABLED);
        }
    }

    private boolean isScopeVisible(ContextTreeConfig config, Set<ItemId> scopes, ItemId scope) {
        return !config.getHiddenScopes().contains(scope.getType()) && (scopes == null || scopes.contains(scope));
    }

    private boolean isHidden(ContextTreeConfig config, ItemInfo info, ItemId scope) {
        boolean hidden = config.getHiddenItems().contains((Object)info.getItemType());
        boolean disabled = config.isHideDisables() && this.isDisabled(info);
        boolean ignored = config.isHideDuplicateRegistrations() && this.isDuplicateRegistration(info, scope);
        boolean hiddenScope = !this.isScopeVisible(config, null, scope) || this.isHiddenBundle(config, info);
        boolean notUsedInstaller = config.isHideNotUsedInstallers() && this.isNotUsedInstaller(info);
        return hidden || disabled || ignored || hiddenScope || notUsedInstaller;
    }

    private boolean isHiddenBundle(ContextTreeConfig config, ItemInfo info) {
        return ConfigItem.Bundle.equals((Object)info.getItemType()) && !this.isScopeVisible(config, null, info.getId());
    }

    private boolean isNotUsedInstaller(ItemInfo info) {
        return info.getItemType() == ConfigItem.Installer && this.service.getExtensions(info.getType()).isEmpty();
    }

    private boolean isDisabled(ItemInfo item) {
        return item instanceof DisableSupport && !((DisableSupport)((Object)item)).isEnabled();
    }

    private boolean isDuplicateRegistration(ItemInfo item, ItemId scope) {
        return !scope.equals(item.getRegistrationScope());
    }
}

