/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.unique;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.context.unique.DuplicateConfigDetector;

public class UniqueItemsDuplicatesDetector
implements DuplicateConfigDetector {
    private final Set<String> items = new HashSet<String>();

    public UniqueItemsDuplicatesDetector(Class<?> ... uniqueItems) {
        Preconditions.checkArgument((uniqueItems.length > 0 ? 1 : 0) != 0, (Object)"No unique items to configured");
        for (Class<?> cls : uniqueItems) {
            this.items.add(this.id(cls));
        }
    }

    @Override
    public Object getDuplicateItem(List<Object> registered, Object newItem) {
        return this.items.contains(this.id(newItem.getClass())) ? registered.get(0) : null;
    }

    private String id(Class<?> cls) {
        return cls.getName();
    }
}

