/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.jupiter.ext.conf;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.extension.RegisterExtension;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.EnableHook;
import ru.vyarus.dropwizard.guice.test.jupiter.env.EnableSetup;
import ru.vyarus.dropwizard.guice.test.jupiter.env.TestEnvironmentSetup;
import ru.vyarus.dropwizard.guice.test.util.RegistrationTrackUtils;

public class TestExtensionsTracker {
    public static final String GUICEY_EXTENSIONS_DEBUG = "guicey.extensions.debug";
    public static final String DEBUG_ENABLED = "true";
    public boolean debug;
    protected final List<String> extensionsSource = new ArrayList<String>();
    protected final List<String> hooksSource = new ArrayList<String>();
    private Class<? extends TestEnvironmentSetup> contextHook;

    public void setContextHook(Class<? extends TestEnvironmentSetup> hook) {
        this.contextHook = hook;
    }

    public final void extensionsFromFields(List<Field> fields, Object instance) {
        RegistrationTrackUtils.fromField(this.extensionsSource, "@" + EnableSetup.class.getSimpleName(), fields, instance);
    }

    @SafeVarargs
    public final void extensionsFromAnnotation(Class<? extends Annotation> ann, Class<? extends TestEnvironmentSetup> ... exts) {
        ArrayList<String> tmp = new ArrayList<String>(this.extensionsSource);
        this.extensionsSource.clear();
        RegistrationTrackUtils.fromClass(this.extensionsSource, "@" + ann.getSimpleName(), exts);
        this.extensionsSource.addAll(tmp);
    }

    public final void hooksFromFields(List<Field> fields, boolean baseHooks, Object instance) {
        if (!fields.isEmpty()) {
            ArrayList<String> tmp;
            ArrayList<String> arrayList = tmp = baseHooks ? new ArrayList<String>(this.hooksSource) : Collections.emptyList();
            if (baseHooks) {
                this.hooksSource.clear();
            }
            RegistrationTrackUtils.fromField(this.hooksSource, "@" + EnableHook.class.getSimpleName(), fields, instance);
            this.hooksSource.addAll(tmp);
        }
    }

    @SafeVarargs
    public final void hooksFromAnnotation(Class<? extends Annotation> ann, Class<? extends GuiceyConfigurationHook> ... exts) {
        RegistrationTrackUtils.fromClass(this.hooksSource, "@" + ann.getSimpleName(), exts);
    }

    public final void extensionInstances(TestEnvironmentSetup ... exts) {
        RegistrationTrackUtils.fromInstance(this.extensionsSource, String.format("@%s instance", RegisterExtension.class.getSimpleName()), exts);
    }

    @SafeVarargs
    public final void extensionClasses(Class<? extends TestEnvironmentSetup> ... exts) {
        RegistrationTrackUtils.fromClass(this.extensionsSource, String.format("@%s class", RegisterExtension.class.getSimpleName()), exts);
    }

    public final void hookInstances(GuiceyConfigurationHook ... exts) {
        RegistrationTrackUtils.fromInstance(this.hooksSource, String.format("%s instance", this.getHookContext()), exts);
    }

    @SafeVarargs
    public final void hookClasses(Class<? extends GuiceyConfigurationHook> ... exts) {
        RegistrationTrackUtils.fromClass(this.hooksSource, String.format("%s class", this.getHookContext()), exts);
    }

    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"})
    public void enableDebugFromSystemProperty() {
        if (!this.debug && DEBUG_ENABLED.equalsIgnoreCase(System.getProperty(GUICEY_EXTENSIONS_DEBUG))) {
            this.debug = true;
        }
    }

    public void logUsedHooksAndSetupObjects(String configPrefix) {
        if (!(!this.debug || this.extensionsSource.isEmpty() && this.hooksSource.isEmpty())) {
            StringBuilder res = new StringBuilder(500).append("\nGuicey test extensions (").append(configPrefix).append(".):\n\n");
            if (!this.extensionsSource.isEmpty()) {
                res.append("\tSetup objects = \n");
                this.logTracks(res, this.extensionsSource);
            }
            if (!this.hooksSource.isEmpty()) {
                res.append("\tTest hooks = \n");
                this.logTracks(res, this.hooksSource);
            }
            System.out.println(res);
        }
    }

    public void logOverriddenConfigs(String configPrefix) {
        if (this.debug) {
            StringBuilder res = new StringBuilder();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(configPrefix)) continue;
                res.append(String.format("\t %20s = %s%n", key.substring(configPrefix.length() + 1), entry.getValue()));
            }
            if (res.length() > 0) {
                System.out.println("\nApplied configuration overrides (" + configPrefix + ".): \n\n" + res);
            }
        }
    }

    private String getHookContext() {
        return this.contextHook != null ? RenderUtils.getClassName(this.contextHook) : "@" + RegisterExtension.class.getSimpleName();
    }

    private void logTracks(StringBuilder res, List<String> tracks) {
        for (String st : tracks) {
            res.append("\t\t").append(st).append('\n');
        }
        res.append('\n');
    }
}

