/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;

public class SystemInMock
extends InputStream {
    private StringReader currentReader;
    private final Supplier<RuntimeException> exception = () -> new IllegalStateException("Console input (" + this.getReads() + ") not provided");
    private int reads;

    public SystemInMock() {
        this.provideText(new String[0]);
    }

    public void provideText(String ... lines) {
        String separator = System.getProperty("line.separator");
        this.currentReader = new StringReader(String.join((CharSequence)separator, lines) + separator);
    }

    @Override
    public int read() throws IOException {
        int character = this.currentReader.read();
        if (character == -1) {
            throw this.exception.get();
        }
        return character;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || len < 0 || len > buffer.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.readNextLine(buffer, offset, len);
    }

    public int getReads() {
        return this.reads;
    }

    private int readNextLine(byte[] buffer, int offset, int len) throws IOException {
        byte read;
        int i;
        ++this.reads;
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        buffer[offset] = (byte)c;
        for (i = 1; i < len && !this.isCompleteLineWritten(buffer, i - 1) && (read = (byte)this.read()) != -1; ++i) {
            buffer[offset + i] = read;
        }
        return i;
    }

    private boolean isCompleteLineWritten(byte[] buffer, int indexLastByteWritten) {
        byte[] separator = System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8);
        int indexFirstByteOfSeparator = indexLastByteWritten - separator.length + 1;
        return indexFirstByteOfSeparator >= 0 && this.contains(buffer, separator, indexFirstByteOfSeparator);
    }

    private boolean contains(byte[] array, byte[] pattern, int indexStart) {
        for (int i = 0; i < pattern.length; ++i) {
            if (array[indexStart + i] == pattern[i]) continue;
            return false;
        }
        return true;
    }
}

