/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug;

import com.google.inject.Binding;
import com.google.inject.spi.Element;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.CallSite;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.eclipse.jetty.util.component.LifeCycle;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.installer.util.BindingUtils;
import ru.vyarus.dropwizard.guice.module.lifecycle.UniqueGuiceyLifecycleListener;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BundlesFromLookupResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.BundlesInitializedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ClasspathExtensionsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.CommandsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ConfigurationHooksProcessedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.DropwizardBundlesInitializedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.InstallersResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.configuration.ManualExtensionsValidatedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.JerseyConfigurationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.jersey.JerseyExtensionsInstalledEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ApplicationRunEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.BundlesStartedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsInstalledEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ExtensionsResolvedEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.InjectorCreationEvent;
import ru.vyarus.dropwizard.guice.module.lifecycle.event.run.ModulesAnalyzedEvent;

public class LifecycleDiagnostic
extends UniqueGuiceyLifecycleListener {
    private static final String BUNDLES = "bundles";
    private static final String DISABLED = "disabled";
    private static final String IGNORED_DUPLICATES = "ignored duplicate instances";
    private static final String NL = "\n";
    private static final String EXTENSIONS = "extensions";
    private static final String INSTALLED_EXTENSIONS = "installed extensions";
    private final boolean showDetails;
    private final StopWatch timer = StopWatch.createStarted();

    public LifecycleDiagnostic(boolean showDetails) {
        this.showDetails = showDetails;
    }

    @Override
    protected void configurationHooksProcessed(ConfigurationHooksProcessedEvent event) {
        this.log("%s hooks processed", event.getHooks().size());
        if (this.showDetails) {
            this.logDetails("hooks", event.getHooks());
        }
    }

    @Override
    protected void dropwizardBundlesInitialized(DropwizardBundlesInitializedEvent event) {
        this.log("Initialized %s%s dropwizard bundles", event.getBundles().size(), this.fmtDisabled(event.getDisabled()));
        if (this.showDetails) {
            this.logDetails(BUNDLES, event.getBundles());
            this.logDetails(DISABLED, event.getDisabled());
            this.logDetails(IGNORED_DUPLICATES, event.getIgnored());
        }
    }

    @Override
    protected void lookupBundlesResolved(BundlesFromLookupResolvedEvent event) {
        this.log("%s lookup bundles recognized", event.getBundles().size());
        if (this.showDetails) {
            this.logDetails(BUNDLES, event.getBundles());
        }
    }

    @Override
    protected void bundlesInitialized(BundlesInitializedEvent event) {
        this.log("Initialized %s%s GuiceyBundles", event.getBundles().size(), this.fmtDisabled(event.getDisabled()));
        if (this.showDetails) {
            this.logDetails(BUNDLES, event.getBundles());
            this.logDetails(DISABLED, event.getDisabled());
            this.logDetails(IGNORED_DUPLICATES, event.getIgnored());
        }
    }

    @Override
    protected void commandsResolved(CommandsResolvedEvent event) {
        if (!event.getCommands().isEmpty()) {
            this.log("%s commands installed", event.getCommands().size());
            if (this.showDetails) {
                this.logDetails("commands", event.getCommands());
            }
        }
    }

    @Override
    protected void installersResolved(InstallersResolvedEvent event) {
        this.log("%s%s installers initialized", event.getInstallers().size(), this.fmtDisabled(event.getDisabled()));
        if (this.showDetails) {
            this.logDetails("installers", event.getInstallers());
            this.logDetails(DISABLED, event.getDisabled());
        }
    }

    @Override
    protected void classpathExtensionsResolved(ClasspathExtensionsResolvedEvent event) {
        this.log("%s classpath extensions detected", event.getExtensions().size());
        if (this.showDetails) {
            this.logDetails(EXTENSIONS, event.getExtensions());
        }
    }

    @Override
    protected void bundlesStarted(BundlesStartedEvent event) {
        this.log("Started %s GuiceyBundles", event.getBundles().size());
        if (this.showDetails) {
            this.logDetails(BUNDLES, event.getBundles());
        }
    }

    @Override
    protected void manualExtensionsValidated(ManualExtensionsValidatedEvent event) {
        this.log("%s manual extensions validated (of %s registered)", event.getValidated().size(), event.getExtensions().size());
        if (this.showDetails) {
            this.logDetails("validated", event.getValidated());
            ArrayList ignored = new ArrayList(event.getExtensions());
            ignored.removeAll(event.getValidated());
            this.logDetails("ignored", ignored);
        }
    }

    @Override
    protected void modulesAnalyzed(ModulesAnalyzedEvent event) {
        this.log("%s binding extensions detected", event.getExtensions().size());
        if (this.showDetails) {
            this.logDetails(EXTENSIONS, event.getExtensions());
            this.logDetails("removed transitive modules", event.getTransitiveModulesRemoved());
            if (!event.getBindingsRemoved().isEmpty()) {
                ArrayList<CallSite> bindings = new ArrayList<CallSite>();
                for (Binding binding : event.getBindingsRemoved()) {
                    List modules = BindingUtils.getModules((Element)binding).stream().sorted(Collections.reverseOrder()).map(it -> it.substring(it.lastIndexOf(".") + 1)).collect(Collectors.toList());
                    bindings.add((CallSite)((Object)(String.join((CharSequence)"/", modules) + " | " + RenderUtils.renderClassLine(binding.getKey().getTypeLiteral().getRawType()))));
                }
                this.logDetails("removed extension bindings", bindings);
            }
        }
    }

    @Override
    protected void extensionsResolved(ExtensionsResolvedEvent event) {
        this.log("%s%s extensions found", event.getExtensions().size(), this.fmtDisabled(event.getDisabled()));
        if (this.showDetails) {
            this.logDetails(EXTENSIONS, event.getExtensions());
            this.logDetails(DISABLED, event.getDisabled());
        }
    }

    @Override
    protected void injectorCreation(InjectorCreationEvent event) {
        this.log("Starting guice with %s/%s%s modules...", event.getModules().size(), event.getOverridingModules().size(), this.fmtDisabled(event.getDisabled()));
        if (this.showDetails) {
            this.logDetails("modules", event.getModules());
            this.logDetails("overriding", event.getOverridingModules());
            this.logDetails(DISABLED, event.getDisabled());
            this.logDetails(IGNORED_DUPLICATES, event.getIgnored());
        }
    }

    @Override
    protected void extensionsInstalled(ExtensionsInstalledEvent event) {
        this.log("%s extensions installed", event.getExtensions().size());
        if (this.showDetails) {
            this.logDetails(INSTALLED_EXTENSIONS, event.getExtensions());
        }
    }

    @Override
    protected void applicationRun(ApplicationRunEvent event) {
        this.log("Guice started, app running...", new Object[0]);
        event.registerJettyListener(new JettyLifecycleListener());
        event.registerJerseyListener(new JerseyEventListener());
    }

    @Override
    protected void jerseyConfiguration(JerseyConfigurationEvent event) {
        this.log("Configuring Jersey...", new Object[0]);
    }

    @Override
    protected void jerseyExtensionsInstalled(JerseyExtensionsInstalledEvent event) {
        this.log("%s Jersey extensions installed", event.getExtensions().size());
        if (this.showDetails) {
            this.logDetails(INSTALLED_EXTENSIONS, event.getExtensions());
        }
    }

    private void log(String message, Object ... args) {
        int gap = 70;
        String time = this.timer.toString();
        String msg = String.format(message, args);
        String topLine = String.format("%73s", "") + String.join((CharSequence)"", Collections.nCopies(msg.length(), "\u2500"));
        String prefix = "__[ " + time + " ]" + String.join((CharSequence)"", Collections.nCopies(64 - time.length(), "_"));
        System.out.println("\n\n" + topLine + NL + prefix + "/  " + msg + "  \\____\n");
    }

    private String fmtDisabled(List items) {
        return items.isEmpty() ? "" : " (-" + items.size() + ")";
    }

    private void logDetails(String message, Collection<?> items) {
        if (items.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder().append('\t').append(message).append(" = \n");
        for (Object item : items) {
            builder.append("\t\t").append(item instanceof String ? item : (item instanceof Proxy ? item.toString() : RenderUtils.renderClassLine(item instanceof Class ? (Class<?>)item : item.getClass()))).append(NL);
        }
        System.out.println(builder.toString());
    }

    private final class JerseyEventListener
    implements ApplicationEventListener {
        private JerseyEventListener() {
        }

        @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
        public void onEvent(ApplicationEvent event) {
            switch (event.getType()) {
                case INITIALIZATION_START: {
                    LifecycleDiagnostic.this.log("Initializing jersey app...", new Object[0]);
                    break;
                }
                case INITIALIZATION_APP_FINISHED: {
                    LifecycleDiagnostic.this.log("Jersey app initialized", new Object[0]);
                    break;
                }
                case INITIALIZATION_FINISHED: {
                    LifecycleDiagnostic.this.log("Jersey initialized", new Object[0]);
                    break;
                }
                case DESTROY_FINISHED: {
                    LifecycleDiagnostic.this.log("Jersey app destroyed", new Object[0]);
                }
            }
        }

        public RequestEventListener onRequest(RequestEvent requestEvent) {
            return null;
        }
    }

    private final class JettyLifecycleListener
    implements LifeCycle.Listener {
        private JettyLifecycleListener() {
        }

        public void lifeCycleStarting(LifeCycle event) {
            LifecycleDiagnostic.this.log("Jetty starting...", new Object[0]);
        }

        public void lifeCycleStarted(LifeCycle event) {
            LifecycleDiagnostic.this.log("Jetty started", new Object[0]);
        }

        public void lifeCycleStopping(LifeCycle event) {
            LifecycleDiagnostic.this.timer.reset();
            LifecycleDiagnostic.this.log("Stopping Jetty...", new Object[0]);
        }

        public void lifeCycleStopped(LifeCycle event) {
            LifecycleDiagnostic.this.log("Jetty stopped", new Object[0]);
        }
    }
}

