/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.guice;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Binding;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Element;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.debug.report.guice.model.BindingDeclaration;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.GuiceModelUtils;
import ru.vyarus.dropwizard.guice.debug.report.guice.util.visitor.GuiceBindingVisitor;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.map.EmptyGenericsMap;

public class GuiceProvisionRenderer {
    private static final GuiceBindingVisitor BINDING_VISITOR = new GuiceBindingVisitor();
    private static final int MAX_PROVISIONS = 5;

    public String render(ListMultimap<Binding<?>, Duration> provisions) {
        List<Provision> parsed = this.process(provisions);
        StringBuilder res = new StringBuilder(1000);
        res.append('\n');
        Multimap<Class<?>, Provision> suspicious = this.findSuspicious(parsed);
        if (!suspicious.isEmpty()) {
            res.append("\n\tPossible mistakes (unqualified JIT bindings):\n");
            suspicious.keySet().stream().sorted(Comparator.comparing(Class::getSimpleName)).forEach(type -> {
                res.append("\n\t\t @Inject ").append(TypeToStringUtils.toStringType((Type)type, (Map)EmptyGenericsMap.getInstance())).append(":\n");
                suspicious.get(type).stream().sorted(Comparator.comparing(Provision::getKey)).forEach(provision -> res.append(String.format("\t\t\t%s ", Character.valueOf(provision.getDeclaration().getSource() == null ? (char)'>' : (char)' '))).append(this.renderProvision("", (Provision)provision)));
            });
        }
        res.append("\n\tOverall ").append(this.countBeans(parsed)).append(" provisions took ").append(PrintUtils.ms(this.countOverall(parsed))).append('\n');
        for (Provision provision : parsed) {
            res.append(this.renderProvision("\t\t", provision));
        }
        return res.toString();
    }

    private List<Provision> process(ListMultimap<Binding<?>, Duration> provisions) {
        ArrayList<Provision> res = new ArrayList<Provision>();
        for (Binding binding : provisions.keySet()) {
            BindingDeclaration declaration = (BindingDeclaration)binding.acceptTargetVisitor((BindingTargetVisitor)BINDING_VISITOR);
            declaration.setScope(GuiceModelUtils.getScope(binding));
            declaration.setSource(GuiceModelUtils.renderSource((Element)binding));
            res.add(new Provision(GuiceModelUtils.renderKey(binding.getKey()), binding, new ArrayList<Duration>(provisions.get((Object)binding)), declaration));
        }
        Comparator<Provision> comparing = Comparator.comparing(Provision::getOverall);
        res.sort(comparing.reversed());
        return res;
    }

    private Duration countOverall(List<Provision> provisions) {
        Duration total = Duration.ZERO;
        for (Provision provision : provisions) {
            total = total.plus(provision.getOverall());
        }
        return total;
    }

    private int countBeans(List<Provision> provisions) {
        int total = 0;
        for (Provision provision : provisions) {
            total += provision.getProvisions().size();
        }
        return total;
    }

    private String renderProvision(String prefix, Provision provision) {
        BindingDeclaration dec = provision.getDeclaration();
        Object time = PrintUtils.ms(provision.getOverall());
        if (provision.getProvisions().size() > 1) {
            time = (String)time + " (" + provision.getProvisions().stream().limit(5L).map(PrintUtils::ms).collect(Collectors.joining(" + "));
            if (provision.getProvisions().size() > 5) {
                time = (String)time + " + ...";
            }
            time = (String)time + ")";
        }
        return String.format("%s%-20s %-16s %-80s %-4s : %-10s \t\t %s%n", prefix, dec.getSource() == null ? "JIT" : dec.getType().name().toLowerCase(), dec.getScope() != null ? "[@" + dec.getScope().getSimpleName() + "]" : "", provision.getKey(), provision.getProvisions().size() > 1 ? "x" + provision.getProvisions().size() : "", time, dec.getSource() != null ? dec.getSource() : "");
    }

    private Multimap<Class<?>, Provision> findSuspicious(List<Provision> provisions) {
        HashMultimap res = HashMultimap.create();
        provisions.forEach(arg_0 -> GuiceProvisionRenderer.lambda$findSuspicious$2((Multimap)res, arg_0));
        res.keySet().removeIf(arg_0 -> GuiceProvisionRenderer.lambda$findSuspicious$3((Multimap)res, arg_0));
        return res;
    }

    private static /* synthetic */ boolean lambda$findSuspicious$3(Multimap res, Class type) {
        if (res.get((Object)type).size() == 1) {
            return true;
        }
        boolean notAnnotated = true;
        for (Provision provision : res.get((Object)type)) {
            notAnnotated = notAnnotated && provision.getBinding().getKey().getAnnotation() != null;
        }
        return notAnnotated;
    }

    private static /* synthetic */ void lambda$findSuspicious$2(Multimap res, Provision provision) {
        res.put((Object)provision.getBinding().getKey().getTypeLiteral().getRawType(), (Object)provision);
    }

    private static class Provision {
        private final String key;
        private final Binding<?> binding;
        private final List<Duration> provisions;
        private final BindingDeclaration declaration;
        private final Duration overall;

        Provision(String key, Binding<?> binding, List<Duration> provisions, BindingDeclaration declaration) {
            this.key = key;
            this.binding = binding;
            this.provisions = provisions;
            this.declaration = declaration;
            Duration overall = Duration.ZERO;
            for (Duration duration : provisions) {
                overall = overall.plus(duration);
            }
            this.overall = overall;
        }

        public String getKey() {
            return this.key;
        }

        public Binding<?> getBinding() {
            return this.binding;
        }

        public List<Duration> getProvisions() {
            return this.provisions;
        }

        public BindingDeclaration getDeclaration() {
            return this.declaration;
        }

        public Duration getOverall() {
            return this.overall;
        }
    }
}

