/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.start;

import com.google.common.base.Stopwatch;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.GuiceBundle;
import ru.vyarus.dropwizard.guice.debug.report.start.StartupTimeInfo;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.context.stat.DetailStat;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatsInfo;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW", "EQ_DOESNT_OVERRIDE_EQUALS", "SE_BAD_FIELD"})
public class DropwizardBundlesTracker
extends ArrayList<ConfiguredBundle> {
    private final Logger logger = LoggerFactory.getLogger(DropwizardBundlesTracker.class);
    private final StatsInfo stats;
    private final StartupTimeInfo info;
    private final Stopwatch webTimer = Stopwatch.createUnstarted();

    public DropwizardBundlesTracker(StatsInfo stats, StartupTimeInfo info, Bootstrap bootstrap) {
        this.stats = stats;
        this.info = info;
        this.injectTracker(bootstrap);
    }

    public Stopwatch getWebTimer() {
        return this.webTimer;
    }

    @Override
    public boolean add(ConfiguredBundle configuredBundle) {
        super.add(new BundleRunTracker(configuredBundle));
        this.info.getBundlesInitPoints().put(configuredBundle.getClass(), this.stats.duration(Stat.OverallTime));
        this.info.setInitTime(this.stats.duration(Stat.OverallTime));
        this.info.setInitInstallersTime(this.stats.duration(Stat.InstallersTime));
        this.info.setInitExtensionsTime(this.stats.duration(Stat.ExtensionsRecognitionTime));
        this.info.setInitListenersTime(this.stats.duration(Stat.ListenersTime));
        if (configuredBundle instanceof GuiceBundle) {
            this.info.getInitEvents().addAll(this.stats.getDetailedStats(DetailStat.Listener).keySet());
        }
        return true;
    }

    @Override
    public void add(int index, ConfiguredBundle element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends ConfiguredBundle> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends ConfiguredBundle> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConfiguredBundle set(int index, ConfiguredBundle element) {
        throw new UnsupportedOperationException();
    }

    private void injectTracker(Bootstrap bootstrap) {
        try {
            Field configuredBundles = Bootstrap.class.getDeclaredField("configuredBundles");
            configuredBundles.setAccessible(true);
            List existing = (List)configuredBundles.get(bootstrap);
            if (!existing.isEmpty()) {
                this.logger.warn("Initialization time not tracked for bundles (move them after guice bundle to measure time): {}", (Object)existing.stream().map(configuredBundle -> RenderUtils.getClassName(configuredBundle.getClass())).collect(Collectors.joining(", ")));
                existing.forEach(this::add);
            }
            configuredBundles.set(bootstrap, this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to inject bootstrap bundles tracker", e);
        }
    }

    private class BundleRunTracker
    implements ConfiguredBundle<Configuration> {
        private final ConfiguredBundle bundle;

        BundleRunTracker(ConfiguredBundle bundle) {
            this.bundle = bundle;
        }

        public void run(Configuration configuration, Environment environment) throws Exception {
            if (DropwizardBundlesTracker.this.info.getDwPreRunTime() == null) {
                DropwizardBundlesTracker.this.info.setDwPreRunTime(DropwizardBundlesTracker.this.stats.duration(Stat.OverallTime).minus(DropwizardBundlesTracker.this.info.getInitTime()));
            }
            Stopwatch bundleTimer = Stopwatch.createStarted();
            this.bundle.run((Object)configuration, environment);
            DropwizardBundlesTracker.this.info.getBundlesRunTimes().put(this.bundle.getClass(), bundleTimer.stop().elapsed());
            DropwizardBundlesTracker.this.info.setRunPoint(DropwizardBundlesTracker.this.stats.duration(Stat.OverallTime));
            DropwizardBundlesTracker.this.info.setRunListenersTime(DropwizardBundlesTracker.this.stats.duration(Stat.ListenersTime).minus(DropwizardBundlesTracker.this.info.getInitListenersTime()));
            DropwizardBundlesTracker.this.webTimer.reset().start();
            if (this.bundle instanceof GuiceBundle) {
                DropwizardBundlesTracker.this.info.getRunEvents().addAll(DropwizardBundlesTracker.this.stats.getDetailedStats(DetailStat.Listener).keySet());
                DropwizardBundlesTracker.this.info.getRunEvents().removeAll(DropwizardBundlesTracker.this.info.getInitEvents());
            }
        }
    }
}

