/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.start;

import com.google.common.base.Stopwatch;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dropwizard.lifecycle.JettyManaged;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import org.eclipse.jetty.util.component.LifeCycle;
import ru.vyarus.dropwizard.guice.debug.report.start.ShutdownTimeInfo;
import ru.vyarus.dropwizard.guice.debug.report.start.StartupTimeInfo;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW", "EQ_DOESNT_OVERRIDE_EQUALS", "SE_BAD_FIELD"})
public class ManagedTracker
extends ArrayList<LifeCycle> {
    private final StartupTimeInfo start;
    private final ShutdownTimeInfo stop;

    public ManagedTracker(StartupTimeInfo start, ShutdownTimeInfo stop, LifecycleEnvironment lifecycle) {
        this.start = start;
        this.stop = stop;
        this.injectTracker(lifecycle);
    }

    @Override
    public boolean add(LifeCycle lifeCycle) {
        return super.add(new LifeCycleTracker(lifeCycle));
    }

    @Override
    public void add(int index, LifeCycle element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends LifeCycle> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends LifeCycle> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LifeCycle set(int index, LifeCycle element) {
        throw new UnsupportedOperationException();
    }

    private void injectTracker(LifecycleEnvironment lifecycle) {
        try {
            Field managedObjects = LifecycleEnvironment.class.getDeclaredField("managedObjects");
            managedObjects.setAccessible(true);
            List existing = (List)managedObjects.get(lifecycle);
            if (!existing.isEmpty()) {
                existing.forEach(this::add);
            }
            managedObjects.set(lifecycle, this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to inject managed objects tracker", e);
        }
    }

    private class LifeCycleTracker
    implements LifeCycle {
        private final LifeCycle object;
        private final boolean managed;
        private final Class<?> type;

        LifeCycleTracker(LifeCycle object) {
            this.object = object;
            this.managed = object instanceof JettyManaged;
            this.type = this.managed ? ((JettyManaged)object).getManaged().getClass() : object.getClass();
        }

        public void start() throws Exception {
            Stopwatch timer = Stopwatch.createStarted();
            this.object.start();
            ManagedTracker.this.start.getManagedTimes().put(this.type, timer.stop().elapsed());
            ManagedTracker.this.start.getManagedTypes().put(this.type, this.managed ? "managed" : "lifecycle");
        }

        public void stop() throws Exception {
            Stopwatch timer = Stopwatch.createStarted();
            this.object.stop();
            ManagedTracker.this.stop.getManagedTimes().put(this.type, timer.stop().elapsed());
            ManagedTracker.this.stop.getManagedTypes().put(this.type, this.managed ? "managed" : "lifecycle");
        }

        public boolean isRunning() {
            return this.object.isRunning();
        }

        public boolean isStarted() {
            return this.object.isStarted();
        }

        public boolean isStarting() {
            return this.object.isStarting();
        }

        public boolean isStopping() {
            return this.object.isStopping();
        }

        public boolean isStopped() {
            return this.object.isStopped();
        }

        public boolean isFailed() {
            return this.object.isFailed();
        }

        public boolean addEventListener(EventListener listener) {
            return this.object.addEventListener(listener);
        }

        public boolean removeEventListener(EventListener listener) {
            return this.object.removeEventListener(listener);
        }
    }
}

