/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.debug.report.start;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import ru.vyarus.dropwizard.guice.debug.report.start.ShutdownTimeInfo;
import ru.vyarus.dropwizard.guice.debug.util.RenderUtils;
import ru.vyarus.dropwizard.guice.module.context.stat.DetailStat;
import ru.vyarus.dropwizard.guice.test.util.PrintUtils;

public class ShutdownTimeRenderer {
    public String render(ShutdownTimeInfo info) {
        StringBuilder res = new StringBuilder(200);
        res.append("\n\n").append(this.line(1, "Application shutdown", info.getStopTime()));
        info.getManagedTimes().forEach((type, duration) -> res.append(this.tab(2)).append(String.format("%-10s", info.getManagedTypes().get(type))).append(this.line(0, RenderUtils.getClassName(type), (Duration)duration)));
        res.append(this.line(2, "Listeners time", info.getListenersTime()));
        info.getStats().getDetailedStats(DetailStat.Listener).forEach((type, time) -> {
            if (info.getEvents().contains(type)) {
                res.append(this.line(3, type.getSimpleName(), (Duration)time));
            }
        });
        return res.toString();
    }

    private String line(int shift, String name, Duration duration) {
        return this.line(shift, name, null, duration, null);
    }

    private String line(int shift, String name, String prefix, Duration duration, String postfix) {
        return this.tab(shift) + this.format(name, prefix, duration, postfix);
    }

    private String format(String name, String prefix, Duration duration, String postfix) {
        return String.format("%-35s: %s%s%s%n", name, MoreObjects.firstNonNull((Object)prefix, (Object)""), PrintUtils.ms(duration), MoreObjects.firstNonNull((Object)postfix, (Object)""));
    }

    private String tab(int shift) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < shift; ++i) {
            res.append('\t');
        }
        return res.toString();
    }
}

