/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.module.context.ConfigItem;
import ru.vyarus.dropwizard.guice.module.context.ConfigurationContext;
import ru.vyarus.dropwizard.guice.module.context.info.ItemId;
import ru.vyarus.dropwizard.guice.module.context.info.ItemInfo;
import ru.vyarus.dropwizard.guice.module.context.info.impl.ItemInfoImpl;

public final class ConfigurationInfo {
    private final Multimap<ConfigItem, ItemId> itemsHolder = LinkedHashMultimap.create();
    private final Map<ItemId, ItemInfo> classTypes = Maps.newHashMap();
    private final Multimap<Class<?>, ItemInfo> instanceTypes = LinkedHashMultimap.create();
    private final List<Class<? extends GuiceyConfigurationHook>> hooks;

    public ConfigurationInfo(ConfigurationContext context) {
        this.hooks = context.getExecutedHookTypes();
        for (ConfigItem type : ConfigItem.values()) {
            for (Object item : context.getItems(type)) {
                ItemId id = ItemId.from(item);
                this.itemsHolder.put((Object)type, id);
                Object info = context.getInfo(item);
                if (((ItemInfoImpl)info).getItemType().isInstanceConfig() && ((ItemInfoImpl)info).getRegistrationAttempts() > 0) {
                    this.instanceTypes.put(((ItemInfoImpl)info).getType(), info);
                    continue;
                }
                this.classTypes.put(id, (ItemInfo)info);
            }
        }
    }

    public <T> List<ItemId<T>> getItems(ConfigItem type) {
        Collection res = this.itemsHolder.get((Object)type);
        return res.isEmpty() ? Collections.emptyList() : new ArrayList(res);
    }

    public <T, K extends ItemInfo> List<ItemId<T>> getItems(ConfigItem type, Predicate<K> filter) {
        List<ItemId<T>> items = this.getItems(type);
        return this.filter(items, filter);
    }

    public List<ItemId<Object>> getItems(Predicate<? extends ItemInfo> filter) {
        ArrayList items = new ArrayList(this.itemsHolder.values());
        return this.filter(items, filter);
    }

    public List<ItemId<Object>> getItems(Class<?> type) {
        List instances = this.getInfos(type);
        if (instances.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ItemId<Object>> res = new ArrayList<ItemId<Object>>();
        for (ItemInfo item : instances) {
            res.add(item.getId());
        }
        return res;
    }

    public <T extends ItemInfo> T getInfo(ItemId id) {
        boolean instanceType;
        if (id.getIdentity() == null) {
            int instancesCnt = this.instanceTypes.get(id.getType()).size();
            Preconditions.checkState((instancesCnt == 0 ? 1 : 0) != 0, (String)"Class id descriptor (%s) can't be used to reach instance configurations: %s. Use getInfos(class) instead.", (Object)id, (int)instancesCnt);
        }
        boolean bl = instanceType = id.getIdentity() != null;
        if (instanceType) {
            for (ItemInfo info : this.instanceTypes.get(id.getType())) {
                if (!info.getId().equals(id)) continue;
                return (T)info;
            }
        }
        return (T)(instanceType ? null : this.classTypes.get(id));
    }

    public <T extends ItemInfo> List<T> getInfos(Class<?> type) {
        ItemId id = ItemId.from(type);
        if (this.instanceTypes.containsKey(id.getType())) {
            return new ArrayList(this.instanceTypes.get(id.getType()));
        }
        ItemInfo res = this.classTypes.get(id);
        return res == null ? Collections.emptyList() : Collections.singletonList(res);
    }

    public <T extends ItemInfo> List<T> getInfos(ConfigItem type, Predicate<T> filter) {
        return this.filterInfos(this.getItems(type), filter);
    }

    public List<Class<? extends GuiceyConfigurationHook>> getHooks() {
        return this.hooks;
    }

    private <T, K extends ItemInfo> List<ItemId<T>> filter(List<ItemId<T>> items, Predicate<K> filter) {
        return items.stream().filter(it -> filter.test(this.getInfo((ItemId)it))).collect(Collectors.toList());
    }

    private <K extends ItemInfo> List<K> filterInfos(List<ItemId<Object>> items, Predicate<K> filter) {
        return items.stream().map(itemId -> this.getInfo((ItemId)itemId)).filter(filter).collect(Collectors.toList());
    }
}

