/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.option.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import ru.vyarus.dropwizard.guice.module.context.option.Option;
import ru.vyarus.dropwizard.guice.module.context.option.internal.OptionHolder;

public final class OptionsSupport<T extends Enum<? extends Option>> {
    private final Map<T, OptionHolder> options = Maps.newHashMap();

    public void set(T option, Object value) {
        Preconditions.checkNotNull((Object)value, (String)"Null value provided for option %s", option);
        Preconditions.checkArgument((boolean)((Option)option).getType().isAssignableFrom(value.getClass()), (String)"Bad value provided for option %s: %s", option, (Object)value);
        this.getOrCreateHolder(option).setValue(value);
    }

    public <P> P get(T option) {
        return (P)this.getOrCreateHolder(option).getValue();
    }

    public OptionHolder getHolder(T option) {
        OptionHolder holder = this.options.get(option);
        Preconditions.checkArgument((holder != null ? 1 : 0) != 0, (String)"Option %s was not used", option);
        return holder;
    }

    public boolean containsOption(T option) {
        return this.options.containsKey(option);
    }

    public Set<T> getOptions() {
        return Sets.newHashSet(this.options.keySet());
    }

    private OptionHolder getOrCreateHolder(T option) {
        OptionHolder holder = this.options.get(option);
        if (holder == null) {
            holder = new OptionHolder((Option)option);
            this.options.put(option, holder);
        }
        return holder;
    }
}

