/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.option.mapper;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import ru.vyarus.dropwizard.guice.module.context.option.Option;
import ru.vyarus.dropwizard.guice.module.context.option.mapper.StringConverter;

public final class OptionParser {
    private OptionParser() {
    }

    public static <T extends Enum> T recognizeOption(String option) {
        Enum res = StringConverter.convert(Enum.class, option);
        Preconditions.checkState((boolean)Option.class.isAssignableFrom(res.getDeclaringClass()), (String)"%s is not an option type (must be enum and implement Option interface)", res.getDeclaringClass());
        return (T)res;
    }

    public static <V, T extends Enum> V parseValue(T option, String value) {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)value), (String)"Empty value is not allowed for option %s", option);
        try {
            return (V)StringConverter.convert(((Option)((Object)option)).getType(), value);
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Failed to convert '%s' value for option %s.%s", value, option.getDeclaringClass().getSimpleName(), option), ex);
        }
    }
}

