/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.option.mapper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import ru.vyarus.dropwizard.guice.module.context.option.Option;
import ru.vyarus.dropwizard.guice.module.context.option.mapper.OptionParser;

public class OptionsMapper {
    private static final String PROP_PREFIX = "prop: ";
    private final Map<Enum<? extends Option>, Object> options = new HashMap<Enum<? extends Option>, Object>();
    private final Set<String> mappedProps = new HashSet<String>();
    private boolean print;

    public OptionsMapper printMappings() {
        this.print = true;
        return this;
    }

    public OptionsMapper props() {
        return this.props("option.");
    }

    public <T extends Enum<? extends Option>> OptionsMapper props(String prefix) {
        for (Object key : System.getProperties().keySet()) {
            String name = (String)key;
            if (this.mappedProps.contains(name) || !name.startsWith(prefix)) continue;
            String optionName = name.substring(prefix.length());
            Object option = OptionParser.recognizeOption(optionName);
            this.register(PROP_PREFIX + name, option, System.getProperty(name), null);
        }
        return this;
    }

    public <T extends Enum<? extends Option>> OptionsMapper prop(String name, T option) {
        return this.prop(name, option, null);
    }

    public <V, T extends Enum<? extends Option>> OptionsMapper prop(String name, T option, Function<String, V> converter) {
        this.mappedProps.add(name);
        this.register(PROP_PREFIX + name, option, System.getProperty(name), converter);
        return this;
    }

    public <T extends Enum<? extends Option>> OptionsMapper env(String name, T option) {
        return this.env(name, option, null);
    }

    public <V, T extends Enum<? extends Option>> OptionsMapper env(String name, T option, Function<String, V> converter) {
        this.register("env: " + name, option, System.getenv(name), converter);
        return this;
    }

    public <V, T extends Enum<? extends Option>> OptionsMapper string(T option, String value) {
        return this.string(option, value, null);
    }

    public <V, T extends Enum<? extends Option>> OptionsMapper string(T option, String value, Function<String, V> converter) {
        this.register("", option, value, converter);
        return this;
    }

    public Map<Enum<? extends Option>, Object> map() {
        return this.options;
    }

    private <T extends Enum<? extends Option>> void register(String source, T option, String value, Function<String, ?> converter) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.options.put(option, converter == null ? OptionParser.parseValue(option, value) : converter.apply(value));
            if (this.print) {
                System.out.printf("\t%-25s  %s.%s = %s", source, option.getDeclaringClass().getSimpleName(), option.name(), value).println();
            }
        }
    }
}

