/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.module.context.stat;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import ru.vyarus.dropwizard.guice.module.context.stat.DetailStat;
import ru.vyarus.dropwizard.guice.module.context.stat.GuiceStatsTracker;
import ru.vyarus.dropwizard.guice.module.context.stat.Stat;
import ru.vyarus.dropwizard.guice.module.context.stat.StatTimer;

public final class StatsTracker {
    private final Map<Stat, StatTimer> timers = Maps.newEnumMap(Stat.class);
    private final Map<Stat, Integer> counters = Maps.newEnumMap(Stat.class);
    private final GuiceStatsTracker guiceStats = new GuiceStatsTracker();
    private final Map<DetailStat, Map<Class<?>, Stopwatch>> detailStats = Maps.newEnumMap(DetailStat.class);

    public StatsTracker() {
        this.timer(Stat.OverallTime);
    }

    public StatTimer timer(Stat name) {
        StatTimer watch = this.timers.computeIfAbsent(name, k -> new StatTimer(Stopwatch.createUnstarted()));
        watch.start();
        return watch;
    }

    public void stopTimer(Stat name) {
        ((StatTimer)Preconditions.checkNotNull((Object)this.timers.get((Object)name), (Object)("No started timer for " + name))).stop();
    }

    public Stopwatch detailTimer(DetailStat name, Class<?> type) {
        return this.detailStats.computeIfAbsent(name, detailStat -> new LinkedHashMap()).computeIfAbsent(type, aClass -> Stopwatch.createUnstarted()).start();
    }

    public void count(Stat name, int count) {
        Integer value = this.counters.get((Object)name);
        value = value == null ? count : value + count;
        this.counters.put(name, value);
    }

    public void startJerseyTimer(Stat name) {
        this.timer(Stat.GuiceyTime);
        if (!Stat.JerseyTime.equals((Object)name)) {
            this.timer(Stat.JerseyTime);
        }
        this.timer(name);
    }

    public void stopJerseyTimer(Stat name) {
        this.timers.get((Object)Stat.GuiceyTime).stop();
        if (!Stat.JerseyTime.equals((Object)name)) {
            this.timers.get((Object)Stat.JerseyTime).stop();
        }
        this.timers.get((Object)name).stop();
    }

    public Map<Stat, Stopwatch> getTimers() {
        return this.timers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((StatTimer)e.getValue()).getStopwatch()));
    }

    public Map<Class<?>, Duration> getDetails(DetailStat name) {
        Map<Class<?>, Stopwatch> details = this.detailStats.get((Object)name);
        if (details == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap res = new LinkedHashMap();
        details.forEach((type, stopwatch) -> res.put((Class<?>)type, stopwatch.elapsed()));
        return res;
    }

    public Map<Stat, Integer> getCounters() {
        return this.counters;
    }

    public GuiceStatsTracker getGuiceStats() {
        return this.guiceStats;
    }

    public void verifyTimersDone() {
        this.timers.get((Object)Stat.OverallTime).stop();
        for (Map.Entry<Stat, Stopwatch> entry : this.getTimers().entrySet()) {
            Preconditions.checkState((!entry.getValue().isRunning() ? 1 : 0) != 0, (String)"Timer is still running after application startup", (Object)((Object)entry.getKey()));
        }
    }
}

